/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.builder;

import org.perfrepo.model.Metric;
import org.perfrepo.model.MetricComparator;
import org.perfrepo.model.builder.TestBuilder;

public class MetricBuilder {
    private TestBuilder parentBuilder;
    private Metric metric;

    public MetricBuilder(TestBuilder parentBuilder, Metric metric) {
        this.parentBuilder = parentBuilder;
        this.metric = metric;
    }

    public MetricBuilder name(String name) {
        this.metric.setName(name);
        return this;
    }

    public MetricBuilder comparator(MetricComparator comparator) {
        this.metric.setComparator(comparator);
        return this;
    }

    public MetricBuilder description(String description) {
        this.metric.setDescription(description);
        return this;
    }

    public TestBuilder test() {
        if (this.parentBuilder == null) {
            throw new IllegalStateException("Parent builder not defined, this is a standalone metric. Call MetricBuilder.build()");
        }
        return this.parentBuilder;
    }

    public Metric build() {
        if (this.parentBuilder != null) {
            throw new IllegalStateException("This metric can't be built as standalone object, call MetricBuilder.test()");
        }
        return this.metric.clone();
    }
}

