/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.perfrepo.model.Tag;
import org.perfrepo.model.Test;
import org.perfrepo.model.TestExecution;
import org.perfrepo.model.TestExecutionParameter;
import org.perfrepo.model.Value;
import org.perfrepo.model.builder.ValueBuilder;

public class TestExecutionBuilder {
    private TestExecution testExecution = new TestExecution();

    public TestExecutionBuilder id(Long id) {
        this.testExecution.setId(id);
        return this;
    }

    public TestExecutionBuilder name(String name) {
        this.testExecution.setName(name);
        return this;
    }

    public TestExecutionBuilder started(Date started) {
        this.testExecution.setStarted(started);
        return this;
    }

    public TestExecutionBuilder comment(String comment) {
        this.testExecution.setComment(comment);
        return this;
    }

    private TestExecutionParameter addParameter(TestExecutionParameter param) {
        TestExecutionParameter existingParameter;
        Collection<TestExecutionParameter> parameters = this.testExecution.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<TestExecutionParameter>();
            this.testExecution.setParameters(parameters);
        }
        if ((existingParameter = this.findParameter(param.getName())) != null) {
            existingParameter.setValue(param.getValue());
        } else {
            parameters.add(param);
        }
        return param;
    }

    private TestExecutionParameter findParameter(String name) {
        if (this.testExecution == null || this.testExecution.getParameters() == null || name == null) {
            return null;
        }
        for (TestExecutionParameter param : this.testExecution.getParameters()) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    private TestExecutionParameter addParameter(String name, String value) {
        return this.addParameter(new TestExecutionParameter(name, value));
    }

    public TestExecutionBuilder parameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    private Tag addTag(String tag) {
        Collection<Tag> tags = this.testExecution.getTags();
        if (tags == null) {
            tags = new ArrayList<Tag>();
            this.testExecution.setTags(tags);
        }
        Tag newTag = new Tag();
        newTag.setName(tag);
        tags.add(newTag);
        return newTag;
    }

    public TestExecutionBuilder tag(String tag) {
        this.addTag(tag);
        return this;
    }

    private Value addValue(Value value) {
        Collection<Value> values = this.testExecution.getValues();
        if (values == null) {
            values = new ArrayList<Value>();
            this.testExecution.setValues(values);
        }
        values.add(value);
        return value;
    }

    public ValueBuilder value() {
        return new ValueBuilder(this, this.addValue(new Value()));
    }

    public TestExecutionBuilder value(String metricName, Double value, String paramName, String paramValue) {
        return this.value().metricName(metricName).resultValue(value).parameter(paramName, paramValue).execution();
    }

    public TestExecutionBuilder value(String metricName, Double value) {
        return this.value().metricName(metricName).resultValue(value).execution();
    }

    public TestExecutionBuilder testId(Long testId) {
        Test test = this.testExecution.getTest();
        if (test == null) {
            test = new Test();
            this.testExecution.setTest(test);
        }
        test.setId(testId);
        return this;
    }

    public TestExecutionBuilder testUid(String testUid) {
        Test test = this.testExecution.getTest();
        if (test == null) {
            test = new Test();
            this.testExecution.setTest(test);
        }
        test.setUid(testUid);
        return this;
    }

    public TestExecution build() {
        return this.testExecution.clone();
    }
}

