/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.user;

import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.perfrepo.model.Entity;
import org.perfrepo.model.FavoriteParameter;
import org.perfrepo.model.Test;
import org.perfrepo.model.UserProperty;
import org.perfrepo.model.user.Group;

@javax.persistence.Entity
@Table(name="\"user\"")
@NamedQueries(value={@NamedQuery(name="User.getSubscribersForTest", query="SELECT distinct user from User user join user.subscribedTests test where test.id = :testId")})
public class User
implements Entity<User>,
Comparable<User> {
    private static final long serialVersionUID = 4616015836066622075L;
    public static final String GET_SUBSCRIBERS_FOR_TEST = "User.getSubscribersForTest";
    @Id
    @SequenceGenerator(name="USER_ID_GENERATOR", sequenceName="USER_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_ID_GENERATOR")
    private Long id;
    @Column(name="username")
    @NotNull
    @Size(max=2047)
    private String username;
    @Column(name="password")
    @NotNull
    @Size(max=300)
    private String password;
    @Column(name="first_name")
    @NotNull(message="{page.profile.firstNameRequired}")
    @Size(max=2047)
    private String firstName;
    @Column(name="last_name")
    @NotNull(message="{page.profile.lastNameRequired}")
    @Size(max=2047)
    private String lastName;
    @Column(name="email")
    @NotNull(message="{page.profile.emailRequired}")
    @Email
    @Size(max=2047)
    private String email;
    @OneToMany(mappedBy="user")
    private Collection<UserProperty> properties;
    @OneToMany(mappedBy="user")
    private Collection<FavoriteParameter> favoriteParameters;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="user_group", joinColumns={@JoinColumn(name="user_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="group_id", nullable=false, updatable=false)})
    private Collection<Group> groups;
    @ManyToMany(mappedBy="subscribers")
    private Collection<Test> subscribedTests;

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Collection<UserProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<UserProperty> properties) {
        this.properties = properties;
    }

    public Collection<FavoriteParameter> getFavoriteParameters() {
        return this.favoriteParameters;
    }

    public void setFavoriteParameters(Collection<FavoriteParameter> favoriteParameters) {
        this.favoriteParameters = favoriteParameters;
    }

    public Collection<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<Group> groups) {
        this.groups = groups;
    }

    public Collection<Test> getSubscribedTests() {
        return this.subscribedTests;
    }

    public void setSubscribedTests(Collection<Test> subscribedTests) {
        this.subscribedTests = subscribedTests;
    }

    @Override
    public int compareTo(User o) {
        return this.username.compareTo(o.username);
    }

    @Override
    public User clone() {
        try {
            return (User)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

