/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.perfrepo.model.Entity;

public class EntityUtils {
    private EntityUtils() {
    }

    public static <T extends Entity<?>> List<T> clone(Collection<T> entities) {
        if (entities == null) {
            return null;
        }
        ArrayList<Entity> result = new ArrayList<Entity>(entities.size());
        for (Entity entity : entities) {
            result.add((Entity)entity.clone());
        }
        return result;
    }

    public static <T extends Entity<T>> T findById(Collection<T> entities, Long id) {
        if (entities == null) {
            return null;
        }
        for (Entity entity : entities) {
            if (!id.equals(entity.getId())) continue;
            return (T)entity;
        }
        return null;
    }

    public static <T extends Entity<T>> T removeById(Collection<T> entities, Long id) {
        if (entities == null) {
            return null;
        }
        for (Entity entity : entities) {
            if (!id.equals(entity.getId())) continue;
            entities.remove(entity);
            return (T)entity;
        }
        return null;
    }

    public static <T extends Entity<T>, V extends Collection<T>> V removeAllById(V allEntities, Collection<T> entitiesToRemove) {
        for (Entity entityToRemove : entitiesToRemove) {
            EntityUtils.removeById(allEntities, entityToRemove.getId());
        }
        return allEntities;
    }

    public static List<Long> extractIds(Collection<? extends Entity<?>> entities) {
        if (entities == null) {
            return null;
        }
        ArrayList<Long> r = new ArrayList<Long>(entities.size());
        for (Entity<?> entity : entities) {
            r.add(entity.getId());
        }
        return r;
    }

    public static <T extends Entity<T>> UpdateSet<T> updateSet(Collection<T> oldSet, Collection<T> newSet) {
        UpdateSet diff = new UpdateSet();
        HashSet<Long> oldIds = oldSet == null ? Collections.emptySet() : new HashSet<Long>(EntityUtils.extractIds(oldSet));
        HashSet<Long> newIds = newSet == null ? Collections.emptySet() : new HashSet<Long>(EntityUtils.extractIds(newSet));
        for (Entity newEntity : newSet) {
            if (newEntity.getId() == null) {
                diff.toAdd.add(newEntity);
                continue;
            }
            if (oldIds.contains(newEntity.getId())) {
                diff.toUpdate.add(newEntity);
                continue;
            }
            diff.removed.add(newEntity);
        }
        for (Entity oldEntity : oldSet) {
            if (newIds.contains(oldEntity.getId())) continue;
            diff.toRemove.add(oldEntity);
        }
        return diff;
    }

    public static class UpdateSet<T extends Entity<T>> {
        public Collection<T> toRemove = new ArrayList<T>();
        public Collection<T> toAdd = new ArrayList<T>();
        public Collection<T> toUpdate = new ArrayList<T>();
        public Collection<T> removed = new ArrayList<T>();
    }
}

