/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.pf4j.ExtensionFactory;
import org.pf4j.Plugin;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.SpringPlugin;
import org.pf4j.spring.SpringPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringExtensionFactory
implements ExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringExtensionFactory.class);
    public static final boolean AUTOWIRE_BY_DEFAULT = true;
    private static final int AUTOWIRE_CONSTRUCTOR = 3;
    protected final PluginManager pluginManager;
    protected final boolean autowire;

    public SpringExtensionFactory(PluginManager pluginManager) {
        this(pluginManager, true);
    }

    public SpringExtensionFactory(PluginManager pluginManager, boolean autowire) {
        this.pluginManager = pluginManager;
        this.autowire = autowire;
        if (!autowire) {
            log.warn("Autowiring is disabled although the only reason for existence of this special factory is supporting spring and its application context.");
        }
    }

    public <T> T create(Class<T> extensionClass) {
        if (!this.autowire) {
            log.warn("Create instance of '" + this.nameOf(extensionClass) + "' without using springs possibilities as autowiring is disabled.");
            return this.createWithoutSpring(extensionClass);
        }
        return (T)this.getApplicationContextBy(extensionClass).map(applicationContext -> this.createWithSpring(extensionClass, (ApplicationContext)applicationContext)).orElseGet(() -> this.createWithoutSpring(extensionClass));
    }

    protected <T> T createWithSpring(Class<T> extensionClass, ApplicationContext applicationContext) {
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        log.debug("Instantiate extension class '" + this.nameOf(extensionClass) + "' by using constructor autowiring.");
        Object autowiredExtension = beanFactory.autowire(extensionClass, 3, false);
        log.trace("Created extension instance by constructor injection: " + autowiredExtension);
        log.debug("Completing autowiring of extension: " + autowiredExtension);
        beanFactory.autowireBean(autowiredExtension);
        log.trace("Autowiring has been completed for extension: " + autowiredExtension);
        return (T)autowiredExtension;
    }

    protected <T> Optional<ApplicationContext> getApplicationContextBy(Class<T> extensionClass) {
        ApplicationContext applicationContext;
        Plugin plugin = Optional.ofNullable(this.pluginManager.whichPlugin(extensionClass)).map(PluginWrapper::getPlugin).orElse(null);
        if (plugin instanceof SpringPlugin) {
            log.debug("  Extension class ' " + this.nameOf(extensionClass) + "' belongs to spring-plugin '" + this.nameOf(plugin) + "' and will be autowired by using its application context.");
            applicationContext = ((SpringPlugin)plugin).getApplicationContext();
        } else if (this.pluginManager instanceof SpringPluginManager) {
            log.debug("  Extension class ' " + this.nameOf(extensionClass) + "' belongs to a non spring-plugin (or main application) '" + this.nameOf(plugin) + ", but the used PF4J plugin-manager is a spring-plugin-manager. Therefore the extension class will be autowired by using the managers application contexts");
            applicationContext = ((SpringPluginManager)this.pluginManager).getApplicationContext();
        } else {
            log.warn("  No application contexts can be used for instantiating extension class '" + this.nameOf(extensionClass) + "'. This extension neither belongs to a PF4J spring-plugin (id: '" + this.nameOf(plugin) + "') nor is the used plugin manager a spring-plugin-manager (used manager: '" + this.nameOf(this.pluginManager.getClass()) + "'). At perspective of PF4J this seems highly uncommon in combination with a factory which only reason for existence is using spring (and its application context) and should at least be reviewed. In fact no autowiring can be applied although autowire flag was set to 'true'. Instantiating will fallback to standard Java reflection.");
            applicationContext = null;
        }
        return Optional.ofNullable(applicationContext);
    }

    protected <T> T createWithoutSpring(Class<T> extensionClass) throws IllegalArgumentException {
        Constructor<?> constructor = this.getPublicConstructorWithShortestParameterList(extensionClass).orElseThrow(() -> new IllegalArgumentException("Extension class '" + this.nameOf(extensionClass) + "' must have at least one public constructor."));
        try {
            log.debug("Instantiate '" + this.nameOf(extensionClass) + "' by calling '" + constructor + "'with standard Java reflection.");
            return (T)constructor.newInstance(this.nullParameters(constructor));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Most likely this exception is thrown because the called constructor (" + constructor + ") cannot handle 'null' parameters. Original message was: " + ex.getMessage(), ex);
        }
    }

    private Optional<Constructor<?>> getPublicConstructorWithShortestParameterList(Class<?> extensionClass) {
        return Stream.of(extensionClass.getConstructors()).min(Comparator.comparing(Constructor::getParameterCount));
    }

    private Object[] nullParameters(Constructor<?> constructor) {
        return new Object[constructor.getParameterCount()];
    }

    private String nameOf(Plugin plugin) {
        return Objects.nonNull(plugin) ? plugin.getWrapper().getPluginId() : "system";
    }

    private <T> String nameOf(Class<T> clazz) {
        return clazz.getName();
    }
}

