/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.Passphrase;
import sop.Profile;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

public class GenerateKeyImpl
implements GenerateKey {
    public static final Profile CURVE25519_PROFILE = new Profile("draft-koch-eddsa-for-openpgp-00", "Generate EdDSA / ECDH keys using Curve25519");
    public static final Profile RSA4096_PROFILE = new Profile("rfc4880", "Generate 4096-bit RSA keys");
    public static final List<Profile> SUPPORTED_PROFILES = Arrays.asList(CURVE25519_PROFILE, RSA4096_PROFILE);
    private boolean armor = true;
    private boolean signingOnly = false;
    private final Set<String> userIds = new LinkedHashSet<String>();
    private Passphrase passphrase = Passphrase.emptyPassphrase();
    private String profile = CURVE25519_PROFILE.getName();

    public GenerateKey noArmor() {
        this.armor = false;
        return this;
    }

    public GenerateKey userId(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public GenerateKey withKeyPassword(String password) {
        this.passphrase = Passphrase.fromPassword((String)password);
        return this;
    }

    public GenerateKey profile(String profileName) {
        for (Profile profile : SUPPORTED_PROFILES) {
            if (!profile.getName().equals(profileName)) continue;
            this.profile = profileName;
            return this;
        }
        throw new SOPGPException.UnsupportedProfile("generate-key", profileName);
    }

    public GenerateKey signingOnly() {
        this.signingOnly = true;
        return this;
    }

    public Ready generate() throws SOPGPException.MissingArg, SOPGPException.UnsupportedAsymmetricAlgo {
        try {
            final PGPSecretKeyRing key = this.generateKeyWithProfile(this.profile, this.userIds, this.passphrase, this.signingOnly);
            return new Ready(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    if (GenerateKeyImpl.this.armor) {
                        ArmoredOutputStream armoredOutputStream = ArmorUtils.toAsciiArmoredStream((PGPKeyRing)key, (OutputStream)outputStream);
                        key.encode((OutputStream)armoredOutputStream);
                        armoredOutputStream.close();
                    } else {
                        key.encode(outputStream);
                    }
                }
            };
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)e);
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
    }

    private PGPSecretKeyRing generateKeyWithProfile(String profile, Set<String> userIds, Passphrase passphrase, boolean signingOnly) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyRingBuilder keyBuilder;
        if (profile.equals(CURVE25519_PROFILE.getName())) {
            keyBuilder = (KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]));
            if (!signingOnly) {
                keyBuilder.addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}));
            }
        } else if (profile.equals(RSA4096_PROFILE.getName())) {
            keyBuilder = (KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]));
            if (!signingOnly) {
                keyBuilder.addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}));
            }
        } else {
            throw new SOPGPException.UnsupportedProfile("generate-key", profile);
        }
        for (String userId : userIds) {
            keyBuilder.addUserId(userId);
        }
        if (!passphrase.isEmpty()) {
            keyBuilder.setPassphrase(passphrase);
        }
        return keyBuilder.build();
    }
}

