/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.decryption_verification.SignatureVerification;
import sop.Verification;
import sop.enums.SignatureMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/sop/VerificationHelper;", "", "()V", "Companion", "pgpainless-sop"})
public final class VerificationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Verification mapVerification(@NotNull SignatureVerification sigVerification) {
        return Companion.mapVerification(sigVerification);
    }

    @JvmStatic
    @Nullable
    public static final SignatureMode getMode(@NotNull PGPSignature signature) {
        return Companion.getMode(signature);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/sop/VerificationHelper$Companion;", "", "()V", "getMode", "Lsop/enums/SignatureMode;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "mapVerification", "Lsop/Verification;", "sigVerification", "Lorg/pgpainless/decryption_verification/SignatureVerification;", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Verification mapVerification(@NotNull SignatureVerification sigVerification) {
            Intrinsics.checkNotNullParameter((Object)sigVerification, (String)"sigVerification");
            Date date = sigVerification.getSignature().getCreationTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"sigVerification.signature.creationTime");
            return new Verification(date, sigVerification.getSigningKey().getSubkeyFingerprint().toString(), sigVerification.getSigningKey().getPrimaryKeyFingerprint().toString(), this.getMode(sigVerification.getSignature()), null);
        }

        @JvmStatic
        @Nullable
        public final SignatureMode getMode(@NotNull PGPSignature signature) {
            SignatureMode signatureMode;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            switch (signature.getSignatureType()) {
                case 0: {
                    signatureMode = SignatureMode.binary;
                    break;
                }
                case 1: {
                    signatureMode = SignatureMode.text;
                    break;
                }
                default: {
                    signatureMode = null;
                }
            }
            return signatureMode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

