/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sop.util.HexUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lsop/SessionKey;", "", "algorithm", "", "key", "", "(B[B)V", "getAlgorithm", "()B", "getKey", "()[B", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "sop-java"})
public final class SessionKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte algorithm;
    @NotNull
    private final byte[] key;
    @NotNull
    private static final Pattern PATTERN;

    public SessionKey(byte algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.algorithm = algorithm;
        this.key = key;
    }

    public final byte getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type sop.SessionKey");
        SessionKey cfr_ignored_0 = (SessionKey)other;
        if (this.algorithm != ((SessionKey)other).algorithm) {
            return false;
        }
        return Arrays.equals(this.key, ((SessionKey)other).key);
    }

    public int hashCode() {
        int hashCode = this.algorithm;
        hashCode = 31 * hashCode + Arrays.hashCode(this.key);
        return hashCode;
    }

    @NotNull
    public String toString() {
        return this.algorithm + ":" + HexUtil.Companion.bytesToHex(this.key);
    }

    public final byte component1() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] component2() {
        return this.key;
    }

    @NotNull
    public final SessionKey copy(byte algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return new SessionKey(algorithm, key);
    }

    public static /* synthetic */ SessionKey copy$default(SessionKey sessionKey, byte by, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            by = sessionKey.algorithm;
        }
        if ((n & 2) != 0) {
            byArray = sessionKey.key;
        }
        return sessionKey.copy(by, byArray);
    }

    @JvmStatic
    @NotNull
    public static final SessionKey fromString(@NotNull String string) {
        return Companion.fromString(string);
    }

    static {
        String string = "^(\\d):([0-9A-F]+)$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        PATTERN = pattern;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\n"}, d2={"Lsop/SessionKey$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "getPATTERN$annotations", "fromString", "Lsop/SessionKey;", "string", "", "sop-java"})
    @SourceDebugExtension(value={"SMAP\nSessionKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionKey.kt\nsop/SessionKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getPATTERN$annotations() {
        }

        @JvmStatic
        @NotNull
        public final SessionKey fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            Pattern pattern = PATTERN;
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            Matcher matcher = pattern.matcher(StringsKt.replace$default(string2, "\n", "", false, 4, null));
            if (!matcher.matches()) {
                boolean bl = false;
                String string3 = "Provided session key does not match expected format.";
                throw new IllegalArgumentException(string3.toString());
            }
            String string4 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            byte by = Byte.parseByte(string4);
            String string5 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue(string5, "group(...)");
            return new SessionKey(by, HexUtil.Companion.hexToBytes(string5));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

