/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

@CommandLine.Command(name="generate-key", resourceBundle="msg_generate-key", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lsop/cli/picocli/commands/GenerateKeyCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "profile", "", "getProfile", "()Ljava/lang/String;", "setProfile", "(Ljava/lang/String;)V", "signingOnly", "getSigningOnly", "setSigningOnly", "userId", "", "getUserId", "()Ljava/util/List;", "setUserId", "(Ljava/util/List;)V", "withKeyPassword", "getWithKeyPassword", "setWithKeyPassword", "run", "", "sop-java-picocli"})
public final class GenerateKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Parameters(paramLabel="USERID")
    @NotNull
    private List<String> userId = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @Nullable
    private String withKeyPassword;
    @CommandLine.Option(names={"--profile"}, paramLabel="PROFILE")
    @Nullable
    private String profile;
    @CommandLine.Option(names={"--signing-only"})
    private boolean signingOnly;

    public GenerateKeyCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @NotNull
    public final List<String> getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.userId = list;
    }

    @Nullable
    public final String getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@Nullable String string) {
        this.withKeyPassword = string;
    }

    @Nullable
    public final String getProfile() {
        return this.profile;
    }

    public final void setProfile(@Nullable String string) {
        this.profile = string;
    }

    public final boolean getSigningOnly() {
        return this.signingOnly;
    }

    public final void setSigningOnly(boolean bl) {
        this.signingOnly = bl;
    }

    @Override
    public void run() {
        GenerateKey generateKey;
        String it;
        GenerateKey generateKey2 = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().generateKey(), "generate-key");
        String string = this.profile;
        if (string != null) {
            it = string;
            boolean bl = false;
            try {
                generateKey = generateKey2.profile(it);
            }
            catch (SOPGPException.UnsupportedProfile e) {
                String[] stringArray = new String[2];
                stringArray[0] = "generate-key";
                Intrinsics.checkNotNull(this.profile);
                String errorMsg = this.getMsg("sop.error.usage.profile_not_supported", stringArray);
                throw new SOPGPException.UnsupportedProfile(errorMsg, e);
            }
        }
        if (this.signingOnly) {
            generateKey2.signingOnly();
        }
        for (String userId : this.userId) {
            generateKey2.userId(userId);
        }
        if (!this.armor) {
            generateKey2.noArmor();
        }
        String string2 = this.withKeyPassword;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(it));
                generateKey = generateKey2.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String[] stringArray = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Ready ready = generateKey2.generate();
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            ready.writeTo(printStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

