/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;

@CommandLine.Command(name="revoke-key", resourceBundle="msg_revoke-key", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lsop/cli/picocli/commands/RevokeKeyCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "withKeyPassword", "", "", "getWithKeyPassword", "()Ljava/util/List;", "setWithKeyPassword", "(Ljava/util/List;)V", "run", "", "sop-java-picocli"})
public final class RevokeKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--with-key-password"}, arity="0..*", paramLabel="PASSWORD")
    @NotNull
    private List<String> withKeyPassword = CollectionsKt.emptyList();

    public RevokeKeyCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @NotNull
    public final List<String> getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withKeyPassword = list;
    }

    @Override
    public void run() {
        Ready ready;
        RevokeKey revokeKey = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().revokeKey(), "revoke-key");
        if (!this.armor) {
            revokeKey.noArmor();
        }
        for (String string : this.withKeyPassword) {
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(string));
                revokeKey.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String[] stringArray = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            ready = revokeKey.keys(inputStream);
        }
        catch (SOPGPException.KeyIsProtected e) {
            String[] stringArray = new String[]{"STANDARD_IN"};
            String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", stringArray);
            throw new SOPGPException.KeyIsProtected(errorMsg, e);
        }
        Ready ready2 = ready;
        try {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            ready2.writeTo(printStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

