/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;

@CommandLine.Command(name="verify", resourceBundle="msg_detached-verify", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lsop/cli/picocli/commands/VerifyCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "certificates", "", "", "getCertificates", "()Ljava/util/List;", "setCertificates", "(Ljava/util/List;)V", "notAfter", "getNotAfter", "()Ljava/lang/String;", "setNotAfter", "(Ljava/lang/String;)V", "notBefore", "getNotBefore", "setNotBefore", "signature", "getSignature", "setSignature", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nVerifyCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyCmd.kt\nsop/cli/picocli/commands/VerifyCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class VerifyCmd
extends AbstractSopCmd {
    @CommandLine.Parameters(index="0", paramLabel="SIGNATURE")
    public String signature;
    @CommandLine.Parameters(index="1..*", arity="1..*", paramLabel="CERT")
    public List<String> certificates;
    @CommandLine.Option(names={"--not-before"}, paramLabel="DATE")
    @NotNull
    private String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, paramLabel="DATE")
    @NotNull
    private String notAfter = "now";

    public VerifyCmd() {
        super(null, 1, null);
    }

    @NotNull
    public final String getSignature() {
        String string = this.signature;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("signature");
        return null;
    }

    public final void setSignature(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.signature = string;
    }

    @NotNull
    public final List<String> getCertificates() {
        List<String> list = this.certificates;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("certificates");
        return null;
    }

    public final void setCertificates(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.certificates = list;
    }

    @NotNull
    public final String getNotBefore() {
        return this.notBefore;
    }

    public final void setNotBefore(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notBefore = string;
    }

    @NotNull
    public final String getNotAfter() {
        return this.notAfter;
    }

    public final void setNotAfter(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notAfter = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Verification> list;
        Object sigIn22;
        DetachedVerify detachedVerify = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().detachedVerify(), "verify");
        try {
            detachedVerify.notAfter(this.parseNotAfter(this.notAfter));
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{"--not-after"};
            String string = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(string, unsupportedOption);
        }
        try {
            detachedVerify.notBefore(this.parseNotBefore(this.notBefore));
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{"--not-before"};
            String string = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(string, unsupportedOption);
        }
        for (String list2 : this.getCertificates()) {
            Object object;
            try {
                Closeable closeable = this.getInput(list2);
                Throwable throwable = null;
                try {
                    InputStream certIn = (InputStream)closeable;
                    boolean bl = false;
                    object = (DetachedVerify)detachedVerify.cert(certIn);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            catch (SOPGPException.BadData badData) {
                object = new String[]{list2};
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", (String)object);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        try {
            Closeable unsupportedOption = this.getInput(this.getSignature());
            Throwable throwable = null;
            try {
                sigIn22 = (InputStream)unsupportedOption;
                boolean bl = false;
                sigIn22 = detachedVerify.signatures((InputStream)sigIn22);
            }
            catch (Throwable sigIn22) {
                Throwable throwable3 = sigIn22;
                throw sigIn22;
            }
            finally {
                CloseableKt.closeFinally(unsupportedOption, throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SOPGPException.BadData badData) {
            sigIn22 = new String[]{this.getSignature()};
            String string = this.getMsg("sop.error.input.not_a_signature", (String)sigIn22);
            throw new SOPGPException.BadData(string, badData);
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            list = detachedVerify.data(inputStream);
        }
        catch (SOPGPException.NoSignature e) {
            String errorMsg = this.getMsg("sop.error.runtime.no_verifiable_signature_found");
            throw new SOPGPException.NoSignature(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        List<Verification> verifications = list;
        for (Verification verification : verifications) {
            System.out.println((Object)verification.toString());
        }
    }
}

