/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli;

import java.util.ResourceBundle;
import picocli.AutoComplete;
import picocli.CommandLine;
import sop.SOP;
import sop.cli.picocli.InitLocale;
import sop.cli.picocli.SOPExceptionExitCodeMapper;
import sop.cli.picocli.SOPExecutionExceptionHandler;
import sop.cli.picocli.commands.ArmorCmd;
import sop.cli.picocli.commands.DearmorCmd;
import sop.cli.picocli.commands.DecryptCmd;
import sop.cli.picocli.commands.EncryptCmd;
import sop.cli.picocli.commands.ExtractCertCmd;
import sop.cli.picocli.commands.GenerateKeyCmd;
import sop.cli.picocli.commands.InlineDetachCmd;
import sop.cli.picocli.commands.InlineSignCmd;
import sop.cli.picocli.commands.InlineVerifyCmd;
import sop.cli.picocli.commands.SignCmd;
import sop.cli.picocli.commands.VerifyCmd;
import sop.cli.picocli.commands.VersionCmd;

@CommandLine.Command(name="sop", resourceBundle="msg_sop", exitCodeOnInvalidInput=69, subcommands={CommandLine.HelpCommand.class, ArmorCmd.class, DearmorCmd.class, DecryptCmd.class, InlineDetachCmd.class, EncryptCmd.class, ExtractCertCmd.class, GenerateKeyCmd.class, SignCmd.class, VerifyCmd.class, InlineSignCmd.class, InlineVerifyCmd.class, VersionCmd.class, AutoComplete.GenerateCompletion.class})
public class SopCLI {
    static SOP SOP_INSTANCE;
    static ResourceBundle cliMsg;
    public static String EXECUTABLE_NAME;
    @CommandLine.Option(names={"--stacktrace"}, description={"Print Stacktrace"}, scope=CommandLine.ScopeType.INHERIT)
    static boolean stacktrace;

    public static void main(String[] args) {
        int exitCode = SopCLI.execute(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int execute(String[] args) {
        new CommandLine(new InitLocale()).parseArgs(args);
        cliMsg = ResourceBundle.getBundle("msg_sop");
        CommandLine cmd = new CommandLine(SopCLI.class);
        cmd.getSubcommands().get("help").setResourceBundle(ResourceBundle.getBundle("msg_help"));
        cmd.getSubcommands().get("generate-completion").getCommandSpec().usageMessage().hidden(true);
        cmd.setCommandName(EXECUTABLE_NAME).setExecutionExceptionHandler(new SOPExecutionExceptionHandler()).setExitCodeExceptionMapper(new SOPExceptionExitCodeMapper()).setCaseInsensitiveEnumValuesAllowed(true);
        return cmd.execute(args);
    }

    public static SOP getSop() {
        if (SOP_INSTANCE == null) {
            String errorMsg = cliMsg.getString("sop.error.runtime.no_backend_set");
            throw new IllegalStateException(errorMsg);
        }
        return SOP_INSTANCE;
    }

    public static void setSopInstance(SOP instance) {
        SOP_INSTANCE = instance;
    }

    static {
        cliMsg = ResourceBundle.getBundle("msg_sop");
        EXECUTABLE_NAME = "sop";
    }
}

