/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;

@CommandLine.Command(name="encrypt", resourceBundle="msg_encrypt", exitCodeOnInvalidInput=37)
public class EncryptCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, paramLabel="{binary|text}")
    EncryptAs type;
    @CommandLine.Option(names={"--with-password"}, paramLabel="PASSWORD")
    List<String> withPassword = new ArrayList<String>();
    @CommandLine.Option(names={"--sign-with"}, paramLabel="KEY")
    List<String> signWith = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    List<String> withKeyPassword = new ArrayList<String>();
    @CommandLine.Parameters(index="0..*", paramLabel="CERTS")
    List<String> certs = new ArrayList<String>();

    @Override
    public void run() {
        String password;
        Encrypt encrypt = this.throwIfUnsupportedSubcommand(SopCLI.getSop().encrypt(), "encrypt");
        if (this.type != null) {
            try {
                encrypt.mode(this.type);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--as");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
        if (this.withPassword.isEmpty() && this.certs.isEmpty()) {
            String errorMsg = this.getMsg("sop.error.usage.password_or_cert_required");
            throw new SOPGPException.MissingArg(errorMsg);
        }
        for (String passwordFileName : this.withPassword) {
            try {
                password = EncryptCmd.stringFromInputStream(this.getInput(passwordFileName));
                encrypt.withPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String passwordFileName : this.withKeyPassword) {
            try {
                password = EncryptCmd.stringFromInputStream(this.getInput(passwordFileName));
                encrypt.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String keyInput : this.signWith) {
            try {
                InputStream keyIn = this.getInput(keyInput);
                try {
                    encrypt.signWith(keyIn);
                }
                finally {
                    if (keyIn == null) continue;
                    keyIn.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", keyInput);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                String errorMsg = this.getMsg("sop.error.runtime.key_uses_unsupported_asymmetric_algorithm", keyInput);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.KeyCannotSign keyCannotSign) {
                String errorMsg = this.getMsg("sop.error.runtime.key_cannot_sign", keyInput);
                throw new SOPGPException.KeyCannotSign(errorMsg, keyCannotSign);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", keyInput);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        for (String certInput : this.certs) {
            try {
                InputStream certIn = this.getInput(certInput);
                try {
                    encrypt.withCert(certIn);
                }
                finally {
                    if (certIn == null) continue;
                    certIn.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                String errorMsg = this.getMsg("sop.error.runtime.cert_uses_unsupported_asymmetric_algorithm", certInput);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.CertCannotEncrypt certCannotEncrypt) {
                String errorMsg = this.getMsg("sop.error.runtime.cert_cannot_encrypt", certInput);
                throw new SOPGPException.CertCannotEncrypt(errorMsg, certCannotEncrypt);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", certInput);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        if (!this.armor) {
            encrypt.noArmor();
        }
        try {
            Ready ready = encrypt.plaintext(System.in);
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

