/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import picocli.CommandLine;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;

@CommandLine.Command(name="decrypt", resourceBundle="msg_decrypt", exitCodeOnInvalidInput=37)
public class DecryptCmd
extends AbstractSopCmd {
    private static final String OPT_SESSION_KEY_OUT = "--session-key-out";
    private static final String OPT_WITH_SESSION_KEY = "--with-session-key";
    private static final String OPT_WITH_PASSWORD = "--with-password";
    private static final String OPT_WITH_KEY_PASSWORD = "--with-key-password";
    private static final String OPT_VERIFICATIONS_OUT = "--verifications-out";
    private static final String OPT_VERIFY_WITH = "--verify-with";
    private static final String OPT_NOT_BEFORE = "--verify-not-before";
    private static final String OPT_NOT_AFTER = "--verify-not-after";
    @CommandLine.Option(names={"--session-key-out"}, paramLabel="SESSIONKEY")
    String sessionKeyOut;
    @CommandLine.Option(names={"--with-session-key"}, paramLabel="SESSIONKEY")
    List<String> withSessionKey = new ArrayList<String>();
    @CommandLine.Option(names={"--with-password"}, paramLabel="PASSWORD")
    List<String> withPassword = new ArrayList<String>();
    @CommandLine.Option(names={"--verifications-out", "--verify-out"}, paramLabel="VERIFICATIONS")
    String verifyOut;
    @CommandLine.Option(names={"--verify-with"}, paramLabel="CERT")
    List<String> certs = new ArrayList<String>();
    @CommandLine.Option(names={"--verify-not-before"}, paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--verify-not-after"}, paramLabel="DATE")
    String notAfter = "now";
    @CommandLine.Parameters(index="0..*", paramLabel="KEY")
    List<String> keys = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    List<String> withKeyPassword = new ArrayList<String>();

    @Override
    public void run() {
        Decrypt decrypt = this.throwIfUnsupportedSubcommand(SopCLI.getSop().decrypt(), "decrypt");
        this.throwIfOutputExists(this.verifyOut);
        this.throwIfOutputExists(this.sessionKeyOut);
        this.setNotAfter(this.notAfter, decrypt);
        this.setNotBefore(this.notBefore, decrypt);
        this.setWithPasswords(this.withPassword, decrypt);
        this.setWithSessionKeys(this.withSessionKey, decrypt);
        this.setWithKeyPassword(this.withKeyPassword, decrypt);
        this.setVerifyWith(this.certs, decrypt);
        this.setDecryptWith(this.keys, decrypt);
        if (this.verifyOut != null && this.certs.isEmpty()) {
            String errorMsg = this.getMsg("sop.error.usage.option_requires_other_option", OPT_VERIFICATIONS_OUT, OPT_VERIFY_WITH);
            throw new SOPGPException.IncompleteVerification(errorMsg);
        }
        try {
            ReadyWithResult<DecryptionResult> ready = decrypt.ciphertext(System.in);
            DecryptionResult result = ready.writeTo(System.out);
            this.writeSessionKeyOut(result);
            this.writeVerifyOut(result);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        catch (SOPGPException.CannotDecrypt e) {
            String errorMsg = this.getMsg("sop.error.runtime.cannot_decrypt_message");
            throw new SOPGPException.CannotDecrypt(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void writeVerifyOut(DecryptionResult result) throws IOException {
        if (this.verifyOut != null) {
            if (result.getVerifications().isEmpty()) {
                String errorMsg = this.getMsg("sop.error.runtime.no_verifiable_signature_found");
                throw new SOPGPException.NoSignature(errorMsg);
            }
            try (OutputStream fileOut = this.getOutput(this.verifyOut);){
                PrintWriter writer = new PrintWriter(fileOut);
                for (Verification verification : result.getVerifications()) {
                    writer.println(verification.toString());
                }
                writer.flush();
            }
        }
    }

    private void writeSessionKeyOut(DecryptionResult result) throws IOException {
        if (this.sessionKeyOut == null) {
            return;
        }
        try (OutputStream outputStream = this.getOutput(this.sessionKeyOut);){
            if (!result.getSessionKey().isPresent()) {
                String errorMsg = this.getMsg("sop.error.runtime.no_session_key_extracted");
                throw new SOPGPException.UnsupportedOption(String.format(errorMsg, OPT_SESSION_KEY_OUT));
            }
            SessionKey sessionKey = result.getSessionKey().get();
            PrintWriter writer = new PrintWriter(outputStream);
            writer.println(sessionKey.toString());
            writer.flush();
        }
    }

    private void setDecryptWith(List<String> keys, Decrypt decrypt) {
        for (String key : keys) {
            try {
                InputStream keyIn = this.getInput(key);
                try {
                    decrypt.withKey(keyIn);
                }
                finally {
                    if (keyIn == null) continue;
                    keyIn.close();
                }
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", key);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", key);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setVerifyWith(List<String> certs, Decrypt decrypt) {
        for (String cert : certs) {
            try {
                InputStream certIn = this.getInput(cert);
                try {
                    decrypt.verifyWithCert(certIn);
                }
                finally {
                    if (certIn == null) continue;
                    certIn.close();
                }
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", cert);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private void setWithSessionKeys(List<String> withSessionKey, Decrypt decrypt) {
        for (String sessionKeyFile : withSessionKey) {
            SessionKey sessionKey;
            String sessionKeyString;
            try {
                sessionKeyString = DecryptCmd.stringFromInputStream(this.getInput(sessionKeyFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                sessionKey = SessionKey.fromString(sessionKeyString);
            }
            catch (IllegalArgumentException e) {
                String errorMsg = this.getMsg("sop.error.input.malformed_session_key");
                throw new IllegalArgumentException(errorMsg, e);
            }
            try {
                decrypt.withSessionKey(sessionKey);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_SESSION_KEY);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
    }

    private void setWithPasswords(List<String> withPassword, Decrypt decrypt) {
        for (String passwordFile : withPassword) {
            try {
                String password = DecryptCmd.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_PASSWORD);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setWithKeyPassword(List<String> withKeyPassword, Decrypt decrypt) {
        for (String passwordFile : withKeyPassword) {
            try {
                String password = DecryptCmd.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_KEY_PASSWORD);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setNotAfter(String notAfter, Decrypt decrypt) {
        Date notAfterDate = this.parseNotAfter(notAfter);
        try {
            decrypt.verifyNotAfter(notAfterDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_NOT_AFTER);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }

    private void setNotBefore(String notBefore, Decrypt decrypt) {
        Date notBeforeDate = this.parseNotBefore(notBefore);
        try {
            decrypt.verifyNotBefore(notBeforeDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_NOT_BEFORE);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }
}

