/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

@CommandLine.Command(name="generate-key", resourceBundle="msg_generate-key", exitCodeOnInvalidInput=37)
public class GenerateKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    boolean armor = true;
    @CommandLine.Parameters(paramLabel="USERID")
    List<String> userId = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    String withKeyPassword;
    @CommandLine.Option(names={"--profile"}, paramLabel="PROFILE")
    String profile;

    @Override
    public void run() {
        GenerateKey generateKey = this.throwIfUnsupportedSubcommand(SopCLI.getSop().generateKey(), "generate-key");
        if (this.profile != null) {
            try {
                generateKey.profile(this.profile);
            }
            catch (SOPGPException.UnsupportedProfile e) {
                String errorMsg = this.getMsg("sop.error.usage.profile_not_supported", "generate-key", this.profile);
                throw new SOPGPException.UnsupportedProfile(errorMsg, e);
            }
        }
        for (String userId : this.userId) {
            generateKey.userId(userId);
        }
        if (!this.armor) {
            generateKey.noArmor();
        }
        if (this.withKeyPassword != null) {
            try {
                String password = GenerateKeyCmd.stringFromInputStream(this.getInput(this.withKeyPassword));
                generateKey.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Ready ready = generateKey.generate();
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

