/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import picocli.CommandLine;
import sop.Profile;
import sop.cli.picocli.Print;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.ListProfiles;

@CommandLine.Command(name="list-profiles", resourceBundle="msg_list-profiles", exitCodeOnInvalidInput=37)
public class ListProfilesCmd
extends AbstractSopCmd {
    @CommandLine.Parameters(paramLabel="COMMAND", arity="1", descriptionKey="subcommand")
    String subcommand;

    @Override
    public void run() {
        ListProfiles listProfiles = this.throwIfUnsupportedSubcommand(SopCLI.getSop().listProfiles(), "list-profiles");
        try {
            for (Profile profile : listProfiles.subcommand(this.subcommand)) {
                Print.outln(profile.toString());
            }
        }
        catch (SOPGPException.UnsupportedProfile e) {
            String errorMsg = this.getMsg("sop.error.feature_support.subcommand_does_not_support_profiles", this.subcommand);
            throw new SOPGPException.UnsupportedProfile(errorMsg, e);
        }
    }
}

