/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import picocli.CommandLine;
import sop.cli.picocli.Print;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.operation.Version;

@CommandLine.Command(name="version", resourceBundle="msg_version", exitCodeOnInvalidInput=37)
public class VersionCmd
extends AbstractSopCmd {
    @CommandLine.ArgGroup
    Exclusive exclusive;

    @Override
    public void run() {
        Version version = this.throwIfUnsupportedSubcommand(SopCLI.getSop().version(), "version");
        if (this.exclusive == null) {
            Print.outln(version.getName() + " " + version.getVersion());
            return;
        }
        if (this.exclusive.extended) {
            Print.outln(version.getExtendedVersion());
            return;
        }
        if (this.exclusive.backend) {
            Print.outln(version.getBackendVersion());
            return;
        }
        if (this.exclusive.sopSpec) {
            Print.outln(version.getSopSpecVersion());
            return;
        }
    }

    static class Exclusive {
        @CommandLine.Option(names={"--extended"})
        boolean extended;
        @CommandLine.Option(names={"--backend"})
        boolean backend;
        @CommandLine.Option(names={"--sop-spec"})
        boolean sopSpec;

        Exclusive() {
        }
    }
}

