/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class UTCUtil {
    public static final SimpleDateFormat UTC_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final SimpleDateFormat[] UTC_PARSERS;

    @Nonnull
    public static Date parseUTCDate(String dateString) throws ParseException {
        ParseException exception = null;
        for (SimpleDateFormat parser : UTC_PARSERS) {
            try {
                return parser.parse(dateString);
            }
            catch (ParseException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    public static String formatUTCDate(Date date) {
        return UTC_FORMATTER.format(date);
    }

    static {
        for (SimpleDateFormat f : UTC_PARSERS = new SimpleDateFormat[]{UTC_FORMATTER, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"), new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'")}) {
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

