/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sop.exception.SOPGPException;
import sop.util.UTCUtil;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\b&\u0018\u0000 02\u00020\u0001:\u000201B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J'\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0017\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0010J\u001a\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\u0010J\u0018\u0010&\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0010J\u0010\u0010)\u001a\u00020\"2\b\u0010*\u001a\u0004\u0018\u00010\u0010J#\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\b\u0010-\u001a\u0004\u0018\u0001H,2\u0006\u0010.\u001a\u00020\u0010\u00a2\u0006\u0002\u0010/R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lsop/cli/picocli/commands/AbstractSopCmd;", "Ljava/lang/Runnable;", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "environmentVariableResolver", "Lsop/cli/picocli/commands/AbstractSopCmd$EnvironmentVariableResolver;", "getEnvironmentVariableResolver", "()Lsop/cli/picocli/commands/AbstractSopCmd$EnvironmentVariableResolver;", "setEnvironmentVariableResolver", "(Lsop/cli/picocli/commands/AbstractSopCmd$EnvironmentVariableResolver;)V", "messages", "Ljava/util/ResourceBundle;", "fileDescriptorFromString", "Ljava/io/File;", "fdString", "", "getInput", "Ljava/io/InputStream;", "indirectInput", "getMsg", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getOutput", "Ljava/io/OutputStream;", "indirectOutput", "parseNotAfter", "Ljava/util/Date;", "notAfter", "parseNotBefore", "notBefore", "throwIfEmptyParameters", "", "arg", "", "parmName", "throwIfMissingArg", "", "argName", "throwIfOutputExists", "output", "throwIfUnsupportedSubcommand", "T", "subcommand", "subcommandName", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "EnvironmentVariableResolver", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nAbstractSopCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSopCmd.kt\nsop/cli/picocli/commands/AbstractSopCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public abstract class AbstractSopCmd
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceBundle messages;
    @NotNull
    private EnvironmentVariableResolver environmentVariableResolver;
    @NotNull
    public static final String PRFX_ENV = "@ENV:";
    @NotNull
    public static final String PRFX_FD = "@FD:";
    @JvmField
    @NotNull
    public static final Date DAWN_OF_TIME;
    @JvmField
    @NotNull
    public static final Date BEGINNING_OF_TIME;
    @JvmField
    @NotNull
    public static final Date END_OF_TIME;
    @JvmField
    @NotNull
    public static final Pattern PATTERN_FD;

    public AbstractSopCmd(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("msg_sop", locale);
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(\"msg_sop\", locale)");
        this.messages = resourceBundle;
        this.environmentVariableResolver = AbstractSopCmd::environmentVariableResolver$lambda$0;
    }

    public /* synthetic */ AbstractSopCmd(Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale2, "getDefault()");
            locale = locale2;
        }
        this(locale);
    }

    @NotNull
    public final EnvironmentVariableResolver getEnvironmentVariableResolver() {
        return this.environmentVariableResolver;
    }

    public final void setEnvironmentVariableResolver(@NotNull EnvironmentVariableResolver environmentVariableResolver) {
        Intrinsics.checkNotNullParameter(environmentVariableResolver, "<set-?>");
        this.environmentVariableResolver = environmentVariableResolver;
    }

    public final void throwIfOutputExists(@Nullable String output) {
        if (output != null) {
            Object it = output;
            boolean bl = false;
            it = new File((String)it);
            boolean bl2 = false;
            if (((File)it).exists()) {
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue(((File)it).getAbsolutePath(), "it.absolutePath");
                String errorMsg = this.getMsg("sop.error.indirect_data_type.output_file_already_exists", stringArray);
                throw new SOPGPException.OutputExists(errorMsg);
            }
        }
    }

    @NotNull
    public final String getMsg(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String string = this.messages.getString(key);
        Intrinsics.checkNotNullExpressionValue(string, "messages.getString(key)");
        return string;
    }

    @NotNull
    public final String getMsg(@NotNull String key, String ... args2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args2, "args");
        String msg = this.messages.getString(key);
        Intrinsics.checkNotNullExpressionValue(msg, "msg");
        String string = msg;
        String[] stringArray = Arrays.copyOf(args2, args2.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return string2;
    }

    public final void throwIfMissingArg(@Nullable Object arg, @NotNull String argName) {
        Intrinsics.checkNotNullParameter(argName, "argName");
        if (arg == null) {
            String[] stringArray = new String[]{argName};
            String errorMsg = this.getMsg("sop.error.usage.argument_required", stringArray);
            throw new SOPGPException.MissingArg(errorMsg);
        }
    }

    public final void throwIfEmptyParameters(@NotNull Collection<?> arg, @NotNull String parmName) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        Intrinsics.checkNotNullParameter(parmName, "parmName");
        if (arg.isEmpty()) {
            String[] stringArray = new String[]{parmName};
            String errorMsg = this.getMsg("sop.error.usage.parameter_required", stringArray);
            throw new SOPGPException.MissingArg(errorMsg);
        }
    }

    public final <T> T throwIfUnsupportedSubcommand(@Nullable T subcommand, @NotNull String subcommandName) {
        Intrinsics.checkNotNullParameter(subcommandName, "subcommandName");
        if (subcommand == null) {
            String[] stringArray = new String[]{subcommandName};
            String errorMsg = this.getMsg("sop.error.feature_support.subcommand_not_supported", stringArray);
            throw new SOPGPException.UnsupportedSubcommand(errorMsg);
        }
        return subcommand;
    }

    @NotNull
    public final InputStream getInput(@NotNull String indirectInput) throws IOException {
        Intrinsics.checkNotNullParameter(indirectInput, "indirectInput");
        String trimmed = ((Object)StringsKt.trim((CharSequence)indirectInput)).toString();
        if (!(!StringsKt.isBlank(trimmed))) {
            boolean $i$a$-require-AbstractSopCmd$getInput$22 = false;
            String $i$a$-require-AbstractSopCmd$getInput$22 = "Input cannot be blank.";
            throw new IllegalArgumentException($i$a$-require-AbstractSopCmd$getInput$22.toString());
        }
        if (StringsKt.startsWith$default(trimmed, PRFX_ENV, false, 2, null)) {
            if (new File(trimmed).exists()) {
                String[] $i$a$-require-AbstractSopCmd$getInput$22 = new String[]{trimmed};
                String errorMsg = this.getMsg("sop.error.indirect_data_type.ambiguous_filename", $i$a$-require-AbstractSopCmd$getInput$22);
                throw new SOPGPException.AmbiguousInput(errorMsg);
            }
            String string = trimmed.substring(5);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            String envName = string;
            String envValue2 = this.environmentVariableResolver.resolveEnvironmentVariable(envName);
            if (envValue2 == null) {
                boolean $i$a$-requireNotNull-AbstractSopCmd$getInput$32 = false;
                String[] stringArray = new String[]{envName};
                String $i$a$-requireNotNull-AbstractSopCmd$getInput$32 = this.getMsg("sop.error.indirect_data_type.environment_variable_not_set", stringArray);
                throw new IllegalArgumentException($i$a$-requireNotNull-AbstractSopCmd$getInput$32.toString());
            }
            if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)envValue2)).toString()).length() > 0)) {
                boolean $i$a$-require-AbstractSopCmd$getInput$42 = false;
                String[] stringArray = new String[]{envName};
                String $i$a$-require-AbstractSopCmd$getInput$42 = this.getMsg("sop.error.indirect_data_type.environment_variable_empty", stringArray);
                throw new IllegalArgumentException($i$a$-require-AbstractSopCmd$getInput$42.toString());
            }
            String $i$a$-requireNotNull-AbstractSopCmd$getInput$32 = envValue2;
            Charset $i$a$-require-AbstractSopCmd$getInput$42 = Charsets.UTF_8;
            byte[] byArray = $i$a$-requireNotNull-AbstractSopCmd$getInput$32.getBytes($i$a$-require-AbstractSopCmd$getInput$42);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            return new ByteArrayInputStream(byArray);
        }
        if (StringsKt.startsWith$default(trimmed, PRFX_FD, false, 2, null)) {
            InputStream envValue2;
            if (new File(trimmed).exists()) {
                String[] envValue2 = new String[]{trimmed};
                String errorMsg = this.getMsg("sop.error.indirect_data_type.ambiguous_filename", envValue2);
                throw new SOPGPException.AmbiguousInput(errorMsg);
            }
            File fdFile = this.fileDescriptorFromString(trimmed);
            try {
                envValue2 = new FileInputStream(fdFile);
            }
            catch (FileNotFoundException e) {
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue(fdFile.getAbsolutePath(), "fdFile.absolutePath");
                String errorMsg = this.getMsg("sop.error.indirect_data_type.file_descriptor_not_found", stringArray);
                throw new IOException(errorMsg, e);
            }
            return envValue2;
        }
        File file = new File(trimmed);
        if (!file.exists()) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(file.getAbsolutePath(), "file.absolutePath");
            String errorMsg = this.getMsg("sop.error.indirect_data_type.input_file_does_not_exist", stringArray);
            throw new SOPGPException.MissingInput(errorMsg);
        }
        if (!file.isFile()) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(file.getAbsolutePath(), "file.absolutePath");
            String errorMsg = this.getMsg("sop.error.indirect_data_type.input_not_a_file", stringArray);
            throw new SOPGPException.MissingInput(errorMsg);
        }
        return new FileInputStream(file);
    }

    @NotNull
    public final OutputStream getOutput(@Nullable String indirectOutput) throws IOException {
        if (indirectOutput == null) {
            boolean $i$a$-requireNotNull-AbstractSopCmd$getOutput$22 = false;
            String $i$a$-requireNotNull-AbstractSopCmd$getOutput$22 = "Output cannot be null.";
            throw new IllegalArgumentException($i$a$-requireNotNull-AbstractSopCmd$getOutput$22.toString());
        }
        String trimmed = ((Object)StringsKt.trim((CharSequence)indirectOutput)).toString();
        if (!(((CharSequence)trimmed).length() > 0)) {
            boolean $i$a$-require-AbstractSopCmd$getOutput$32 = false;
            String $i$a$-require-AbstractSopCmd$getOutput$32 = "Output cannot be blank.";
            throw new IllegalArgumentException($i$a$-require-AbstractSopCmd$getOutput$32.toString());
        }
        if (StringsKt.startsWith$default(trimmed, PRFX_ENV, false, 2, null)) {
            String errorMsg = this.getMsg("sop.error.indirect_data_type.illegal_use_of_env_designator");
            throw new SOPGPException.UnsupportedSpecialPrefix(errorMsg);
        }
        if (StringsKt.startsWith$default(trimmed, PRFX_FD, false, 2, null)) {
            OutputStream $i$a$-require-AbstractSopCmd$getOutput$32;
            File fdFile = this.fileDescriptorFromString(trimmed);
            try {
                $i$a$-require-AbstractSopCmd$getOutput$32 = new FileOutputStream(fdFile);
            }
            catch (FileNotFoundException e) {
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue(fdFile.getAbsolutePath(), "fdFile.absolutePath");
                String errorMsg = this.getMsg("sop.error.indirect_data_type.file_descriptor_not_found", stringArray);
                throw new IOException(errorMsg, e);
            }
            return $i$a$-require-AbstractSopCmd$getOutput$32;
        }
        File file = new File(trimmed);
        if (file.exists()) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(file.getAbsolutePath(), "file.absolutePath");
            String errorMsg = this.getMsg("sop.error.indirect_data_type.output_file_already_exists", stringArray);
            throw new SOPGPException.OutputExists(errorMsg);
        }
        if (!file.createNewFile()) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(file.getAbsolutePath(), "file.absolutePath");
            String errorMsg = this.getMsg("sop.error.indirect_data_type.output_file_cannot_be_created", stringArray);
            throw new IOException(errorMsg);
        }
        return new FileOutputStream(file);
    }

    @NotNull
    public final File fileDescriptorFromString(@NotNull String fdString) {
        Intrinsics.checkNotNullParameter(fdString, "fdString");
        File fdDir = new File("/dev/fd/");
        if (!fdDir.exists()) {
            String errorMsg = this.getMsg("sop.error.indirect_data_type.designator_fd_not_supported");
            throw new SOPGPException.UnsupportedSpecialPrefix(errorMsg);
        }
        String string = fdString.substring(4);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        String fdNumber = string;
        if (!PATTERN_FD.matcher(fdNumber).matches()) {
            boolean bl = false;
            String string2 = "File descriptor must be a positive number.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new File(fdDir, fdNumber);
    }

    @NotNull
    public final Date parseNotAfter(@NotNull String notAfter) {
        Date date;
        Intrinsics.checkNotNullParameter(notAfter, "notAfter");
        String string = notAfter;
        if (Intrinsics.areEqual(string, "now")) {
            date = new Date();
        } else if (Intrinsics.areEqual(string, "-")) {
            date = END_OF_TIME;
        } else {
            Date date2;
            try {
                date2 = UTCUtil.Companion.parseUTCDate(notAfter);
            }
            catch (ParseException e) {
                String errorMsg = this.getMsg("sop.error.input.malformed_not_after");
                throw new IllegalArgumentException(errorMsg);
            }
            date = date2;
        }
        return date;
    }

    @NotNull
    public final Date parseNotBefore(@NotNull String notBefore) {
        Date date;
        Intrinsics.checkNotNullParameter(notBefore, "notBefore");
        String string = notBefore;
        if (Intrinsics.areEqual(string, "now")) {
            date = new Date();
        } else if (Intrinsics.areEqual(string, "-")) {
            date = DAWN_OF_TIME;
        } else {
            Date date2;
            try {
                date2 = UTCUtil.Companion.parseUTCDate(notBefore);
            }
            catch (ParseException e) {
                String errorMsg = this.getMsg("sop.error.input.malformed_not_before");
                throw new IllegalArgumentException(errorMsg);
            }
            date = date2;
        }
        return date;
    }

    private static final String environmentVariableResolver$lambda$0(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return System.getenv(name);
    }

    public AbstractSopCmd() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final String stringFromInputStream(@NotNull InputStream inputStream) throws IOException {
        return Companion.stringFromInputStream(inputStream);
    }

    static {
        BEGINNING_OF_TIME = DAWN_OF_TIME = new Date(0L);
        END_OF_TIME = new Date(8640000000000000L);
        String string = "^\\d{1,20}$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(this, flags)");
        PATTERN_FD = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsop/cli/picocli/commands/AbstractSopCmd$Companion;", "", "()V", "BEGINNING_OF_TIME", "Ljava/util/Date;", "getBEGINNING_OF_TIME$annotations", "DAWN_OF_TIME", "END_OF_TIME", "PATTERN_FD", "Ljava/util/regex/Pattern;", "PRFX_ENV", "", "PRFX_FD", "stringFromInputStream", "inputStream", "Ljava/io/InputStream;", "sop-java-picocli"})
    @SourceDebugExtension(value={"SMAP\nAbstractSopCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSopCmd.kt\nsop/cli/picocli/commands/AbstractSopCmd$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Replace with DAWN_OF_TIME", replaceWith=@ReplaceWith(expression="DAWN_OF_TIME", imports={}))
        public static /* synthetic */ void getBEGINNING_OF_TIME$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final String stringFromInputStream(@NotNull InputStream inputStream) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                int read = 0;
                while (true) {
                    int n;
                    int it = n = input.read(buf);
                    boolean bl2 = false;
                    read = it;
                    if (n == -1) break;
                    byteOut.write(buf, 0, read);
                }
                byte[] byArray = byteOut.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "byteOut.toByteArray()");
                string = UTF8Util.Companion.decodeUTF8(byArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lsop/cli/picocli/commands/AbstractSopCmd$EnvironmentVariableResolver;", "", "resolveEnvironmentVariable", "", "name", "sop-java-picocli"})
    public static interface EnvironmentVariableResolver {
        @Nullable
        public String resolveEnvironmentVariable(@NotNull String var1);
    }
}

