/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.ReadyWithResult;
import sop.Signatures;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.operation.InlineDetach;

@CommandLine.Command(name="inline-detach", resourceBundle="msg_inline-detach", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lsop/cli/picocli/commands/InlineDetachCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "signaturesOut", "", "getSignaturesOut", "()Ljava/lang/String;", "setSignaturesOut", "(Ljava/lang/String;)V", "run", "", "sop-java-picocli"})
public final class InlineDetachCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--signatures-out"}, paramLabel="SIGNATURES")
    @Nullable
    private String signaturesOut;
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;

    public InlineDetachCmd() {
        super(null, 1, null);
    }

    @Nullable
    public final String getSignaturesOut() {
        return this.signaturesOut;
    }

    public final void setSignaturesOut(@Nullable String string) {
        this.signaturesOut = string;
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InlineDetach inlineDetach = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().inlineDetach(), "inline-detach");
        this.throwIfOutputExists(this.signaturesOut);
        this.throwIfMissingArg(this.signaturesOut, "--signatures-out");
        if (!this.armor) {
            inlineDetach.noArmor();
        }
        try {
            Closeable closeable = this.getOutput(this.signaturesOut);
            Throwable throwable = null;
            try {
                OutputStream sigOut = (OutputStream)closeable;
                boolean bl = false;
                InputStream inputStream = System.in;
                Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
                ReadyWithResult<Signatures> readyWithResult = inlineDetach.message(inputStream);
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue(printStream, "out");
                readyWithResult.writeTo(printStream).writeTo(sigOut);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

