/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsop/util/ProxyOutputStream;", "Ljava/io/OutputStream;", "()V", "buffer", "Ljava/io/ByteArrayOutputStream;", "swapped", "close", "", "flush", "replaceOutputStream", "underlying", "write", "b", "", "off", "", "len", "i", "sop-java"})
public final class ProxyOutputStream
extends OutputStream {
    @NotNull
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    @Nullable
    private OutputStream swapped;

    public final synchronized void replaceOutputStream(@NotNull OutputStream underlying) {
        Intrinsics.checkNotNullParameter(underlying, "underlying");
        OutputStream outputStream = this.swapped = underlying;
        Intrinsics.checkNotNull(outputStream);
        outputStream.write(this.buffer.toByteArray());
    }

    @Override
    public synchronized void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter(b, "b");
        if (this.swapped == null) {
            this.buffer.write(b);
        } else {
            OutputStream outputStream = this.swapped;
            Intrinsics.checkNotNull(outputStream);
            outputStream.write(b);
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter(b, "b");
        if (this.swapped == null) {
            this.buffer.write(b, off, len);
        } else {
            OutputStream outputStream = this.swapped;
            Intrinsics.checkNotNull(outputStream);
            outputStream.write(b, off, len);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.buffer.flush();
        if (this.swapped != null) {
            OutputStream outputStream = this.swapped;
            Intrinsics.checkNotNull(outputStream);
            outputStream.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.buffer.close();
        if (this.swapped != null) {
            OutputStream outputStream = this.swapped;
            Intrinsics.checkNotNull(outputStream);
            outputStream.close();
        }
    }

    @Override
    public synchronized void write(int i) throws IOException {
        if (this.swapped == null) {
            this.buffer.write(i);
        } else {
            OutputStream outputStream = this.swapped;
            Intrinsics.checkNotNull(outputStream);
            outputStream.write(i);
        }
    }
}

