/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import sop.util.UTCUtil;

public class JUtils {
    public static boolean arrayStartsWith(byte[] array, byte[] start) {
        return JUtils.arrayStartsWith(array, start, 0);
    }

    public static boolean arrayStartsWith(byte[] array, byte[] start, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (start.length + offset > array.length) {
            return false;
        }
        for (int i = 0; i < start.length; ++i) {
            if (array[offset + i] == start[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertArrayStartsWith(byte[] array, byte[] start) {
        if (!JUtils.arrayStartsWith(array, start)) {
            byte[] actual = new byte[Math.min(start.length, array.length)];
            System.arraycopy(array, 0, actual, 0, actual.length);
            Assertions.fail((String)("Array does not start with expected bytes.\nExpected: <" + Arrays.toString(start) + ">\nActual: <" + Arrays.toString(actual) + ">"));
        }
    }

    public static void assertArrayStartsWith(byte[] array, byte[] start, int offset) {
        if (!JUtils.arrayStartsWith(array, start, offset)) {
            byte[] actual = new byte[Math.min(start.length, array.length - offset)];
            System.arraycopy(array, offset, actual, 0, actual.length);
            Assertions.fail((String)("Array does not start with expected bytes at offset " + offset + ".\nExpected: <" + Arrays.toString(start) + ">\nActual: <" + Arrays.toString(actual) + ">"));
        }
    }

    public static boolean arrayEndsWith(byte[] array, byte[] end) {
        return JUtils.arrayEndsWith(array, end, 0);
    }

    public static boolean arrayEndsWith(byte[] array, byte[] end, int offset) {
        if (end.length + offset > array.length) {
            return false;
        }
        for (int i = 0; i < end.length; ++i) {
            int arrOff = array.length - end.length - offset;
            if (end[i] == array[arrOff + i]) continue;
            return false;
        }
        return true;
    }

    public static void assertArrayEndsWith(byte[] array, byte[] end) {
        JUtils.assertArrayEndsWith(array, end, 0);
    }

    public static void assertArrayEndsWith(byte[] array, byte[] end, int offset) {
        if (!JUtils.arrayEndsWith(array, end, offset)) {
            byte[] actual = new byte[Math.min(end.length, array.length - offset)];
            System.arraycopy(array, array.length - actual.length, actual, 0, actual.length);
            Assertions.fail((String)("Array does not end with the expected bytes.\nExpected: <" + Arrays.toString(end) + ">\nActual: <" + Arrays.toString(actual) + ">"));
        }
    }

    public static void assertArrayEndsWithIgnoreNewlines(byte[] array, byte[] end) {
        int offset;
        for (offset = 0; offset < array.length && array[array.length - 1 - offset] == 10; ++offset) {
        }
        JUtils.assertArrayEndsWith(array, end, offset);
    }

    public static void assertAsciiArmorEquals(byte[] first, byte[] second) {
        byte[] firstCleaned = JUtils.removeArmorHeaders(first);
        byte[] secondCleaned = JUtils.removeArmorHeaders(second);
        Assertions.assertArrayEquals((byte[])firstCleaned, (byte[])secondCleaned);
    }

    public static byte[] removeArmorHeaders(byte[] armor) {
        String string = new String(armor, StandardCharsets.UTF_8);
        string = string.replaceAll("Comment: .+\\R", "").replaceAll("Version: .+\\R", "").replaceAll("MessageID: .+\\R", "").replaceAll("Hash: .+\\R", "").replaceAll("Charset: .+\\R", "");
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static void assertDateEquals(Date expected, Date actual) {
        Assertions.assertEquals((Object)UTCUtil.formatUTCDate((Date)expected), (Object)UTCUtil.formatUTCDate((Date)actual));
    }

    public static boolean dateEquals(Date expected, Date actual) {
        return UTCUtil.formatUTCDate((Date)expected).equals(UTCUtil.formatUTCDate((Date)actual));
    }
}

