/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.assertions;

import java.util.Date;
import org.junit.jupiter.api.Assertions;
import sop.Verification;
import sop.enums.SignatureMode;
import sop.testsuite.JUtils;

public final class VerificationAssert {
    private final Verification verification;

    public static VerificationAssert assertThatVerification(Verification verification) {
        return new VerificationAssert(verification);
    }

    private VerificationAssert(Verification verification) {
        this.verification = verification;
    }

    public VerificationAssert issuedBy(String signingKeyFingerprint, String primaryFingerprint) {
        return this.isBySigningKey(signingKeyFingerprint).issuedBy(primaryFingerprint);
    }

    public VerificationAssert issuedBy(String primaryFingerprint) {
        Assertions.assertEquals((Object)primaryFingerprint, (Object)this.verification.getSigningCertFingerprint());
        return this;
    }

    public VerificationAssert isBySigningKey(String signingKeyFingerprint) {
        Assertions.assertEquals((Object)signingKeyFingerprint, (Object)this.verification.getSigningKeyFingerprint());
        return this;
    }

    public VerificationAssert isCreatedAt(Date creationDate) {
        JUtils.assertDateEquals(creationDate, this.verification.getCreationTime());
        return this;
    }

    public VerificationAssert hasDescription(String description) {
        Assertions.assertEquals((Object)description, (Object)this.verification.getDescription().get());
        return this;
    }

    public VerificationAssert hasDescriptionOrNull(String description) {
        if (this.verification.getDescription().isEmpty()) {
            return this;
        }
        return this.hasDescription(description);
    }

    public VerificationAssert hasMode(SignatureMode mode) {
        Assertions.assertEquals((Object)mode, (Object)this.verification.getSignatureMode().get());
        return this;
    }

    public VerificationAssert hasModeOrNull(SignatureMode mode) {
        if (this.verification.getSignatureMode().isEmpty()) {
            return this;
        }
        return this.hasMode(mode);
    }
}

