/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.assertions;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import sop.Verification;
import sop.testsuite.assertions.VerificationAssert;

public final class VerificationListAssert {
    private final List<Verification> verificationList = new ArrayList<Verification>();

    private VerificationListAssert(List<Verification> verifications) {
        this.verificationList.addAll(verifications);
    }

    public static VerificationListAssert assertThatVerificationList(List<Verification> verifications) {
        return new VerificationListAssert(verifications);
    }

    public VerificationListAssert isEmpty() {
        Assertions.assertTrue((boolean)this.verificationList.isEmpty());
        return this;
    }

    public VerificationListAssert isNotEmpty() {
        Assertions.assertFalse((boolean)this.verificationList.isEmpty());
        return this;
    }

    public VerificationListAssert sizeEquals(int size) {
        Assertions.assertEquals((int)size, (int)this.verificationList.size());
        return this;
    }

    public VerificationAssert hasSingleItem() {
        this.sizeEquals(1);
        return VerificationAssert.assertThatVerification(this.verificationList.get(0));
    }

    public VerificationListAssert containsVerificationByCert(String primaryFingerprint) {
        for (Verification verification : this.verificationList) {
            if (!primaryFingerprint.equals(verification.getSigningCertFingerprint())) continue;
            return this;
        }
        Assertions.fail((String)("No verification was issued by certificate " + primaryFingerprint));
        return this;
    }

    public VerificationListAssert containsVerificationBy(String signingKeyFingerprint, String primaryFingerprint) {
        for (Verification verification : this.verificationList) {
            if (!primaryFingerprint.equals(verification.getSigningCertFingerprint()) || !signingKeyFingerprint.equals(verification.getSigningKeyFingerprint())) continue;
            return this;
        }
        Assertions.fail((String)("No verification was issued by key " + signingKeyFingerprint + " of cert " + primaryFingerprint));
        return this;
    }
}

