/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.provider.Arguments;
import sop.SOP;
import sop.testsuite.AbortOnUnsupportedOption;
import sop.testsuite.AbortOnUnsupportedOptionExtension;
import sop.testsuite.SOPInstanceFactory;

@ExtendWith(value={AbortOnUnsupportedOptionExtension.class})
@AbortOnUnsupportedOption
public abstract class AbstractSOPTest {
    private static final List<Arguments> backends = new ArrayList<Arguments>();

    private static void initBackends() {
        SOPInstanceFactory factory;
        String factoryName = System.getenv("test.implementation");
        if (factoryName == null) {
            return;
        }
        try {
            Class<?> testSubjectFactoryClass = Class.forName(factoryName);
            factory = (SOPInstanceFactory)testSubjectFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Map<String, SOP> testSubjects = factory.provideSOPInstances();
        for (String key : testSubjects.keySet()) {
            backends.add(Arguments.of((Object[])new Object[]{Named.of((String)key, (Object)testSubjects.get(key))}));
        }
    }

    public static Stream<Arguments> provideBackends() {
        return backends.stream();
    }

    public static boolean hasBackends() {
        return !backends.isEmpty();
    }

    static {
        AbstractSOPTest.initBackends();
    }
}

