/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.operation.DetachedSign;
import sop.testsuite.JUtils;
import sop.testsuite.TestData;
import sop.testsuite.operation.AbstractSOPTest;
import sop.util.UTF8Util;

@EnabledIf(value="sop.testsuite.operation.AbstractSOPTest#hasBackends")
public class ChangeKeyPasswordTest
extends AbstractSOPTest {
    static Stream<Arguments> provideInstances() {
        return AbstractSOPTest.provideBackends();
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordFromUnprotectedToProtected(SOP sop) throws IOException {
        byte[] unprotectedKey = sop.generateKey().generate().getBytes();
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] protectedKey = sop.changeKeyPassword().newKeyPassphrase(password).keys(unprotectedKey).getBytes();
        ((DetachedSign)((DetachedSign)sop.sign().withKeyPassword(password)).key(protectedKey)).data("Test123".getBytes(StandardCharsets.UTF_8));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordFromUnprotectedToUnprotected(SOP sop) throws IOException {
        byte[] unprotectedKey = sop.generateKey().noArmor().generate().getBytes();
        byte[] stillUnprotectedKey = sop.changeKeyPassword().noArmor().keys(unprotectedKey).getBytes();
        Assertions.assertArrayEquals((byte[])unprotectedKey, (byte[])stillUnprotectedKey);
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordFromProtectedToUnprotected(SOP sop) throws IOException {
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] protectedKey = sop.generateKey().withKeyPassword(password).generate().getBytes();
        byte[] unprotectedKey = sop.changeKeyPassword().oldKeyPassphrase(password).keys(protectedKey).getBytes();
        ((DetachedSign)sop.sign().key(unprotectedKey)).data("Test123".getBytes(StandardCharsets.UTF_8));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordFromProtectedToDifferentProtected(SOP sop) throws IOException {
        byte[] oldPassword = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] newPassword = "0r4ng3".getBytes(UTF8Util.UTF8);
        byte[] protectedKey = sop.generateKey().withKeyPassword(oldPassword).generate().getBytes();
        byte[] reprotectedKey = sop.changeKeyPassword().oldKeyPassphrase(oldPassword).newKeyPassphrase(newPassword).keys(protectedKey).getBytes();
        ((DetachedSign)((DetachedSign)sop.sign().key(reprotectedKey)).withKeyPassword(newPassword)).data("Test123".getBytes(StandardCharsets.UTF_8));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void changePasswordWithWrongOldPasswordFails(SOP sop) throws IOException {
        byte[] oldPassword = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] newPassword = "monkey123".getBytes(UTF8Util.UTF8);
        byte[] wrongPassword = "0r4ng3".getBytes(UTF8Util.UTF8);
        byte[] protectedKey = sop.generateKey().withKeyPassword(oldPassword).generate().getBytes();
        Assertions.assertThrows(SOPGPException.KeyIsProtected.class, () -> sop.changeKeyPassword().oldKeyPassphrase(wrongPassword).newKeyPassphrase(newPassword).keys(protectedKey).getBytes());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void nonUtf8PasswordsFail(SOP sop) {
        Assertions.assertThrows(SOPGPException.PasswordNotHumanReadable.class, () -> sop.changeKeyPassword().oldKeyPassphrase(new byte[]{-1, -2}));
        Assertions.assertThrows(SOPGPException.PasswordNotHumanReadable.class, () -> sop.changeKeyPassword().newKeyPassphrase(new byte[]{-1, -2}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void testNoArmor(SOP sop) throws IOException {
        byte[] oldPassword = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] newPassword = "0r4ng3".getBytes(UTF8Util.UTF8);
        byte[] protectedKey = sop.generateKey().withKeyPassword(oldPassword).generate().getBytes();
        byte[] armored = sop.changeKeyPassword().oldKeyPassphrase(oldPassword).newKeyPassphrase(newPassword).keys(protectedKey).getBytes();
        JUtils.assertArrayStartsWith(armored, TestData.BEGIN_PGP_PRIVATE_KEY_BLOCK);
        byte[] unarmored = sop.changeKeyPassword().noArmor().oldKeyPassphrase(oldPassword).newKeyPassphrase(newPassword).keys(protectedKey).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(unarmored, TestData.BEGIN_PGP_PRIVATE_KEY_BLOCK));
    }
}

