/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import sop.ByteArrayAndResult;
import sop.SOP;
import sop.Signatures;
import sop.operation.DetachedVerify;
import sop.operation.InlineSign;
import sop.testsuite.JUtils;
import sop.testsuite.TestData;
import sop.testsuite.operation.AbstractSOPTest;

@EnabledIf(value="sop.testsuite.operation.AbstractSOPTest#hasBackends")
public class InlineSignInlineDetachDetachedVerifyTest
extends AbstractSOPTest {
    static Stream<Arguments> provideInstances() {
        return InlineSignInlineDetachDetachedVerifyTest.provideBackends();
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void inlineSignThenDetachThenDetachedVerifyTest(SOP sop) throws IOException {
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(message).getBytes();
        ByteArrayAndResult bytesAndResult = sop.inlineDetach().message(inlineSigned).toByteArrayAndResult();
        byte[] plaintext = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])plaintext);
        byte[] signatures = ((Signatures)bytesAndResult.getResult()).getBytes();
        List verifications = ((DetachedVerify)sop.detachedVerify().cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).signatures(signatures).data(plaintext);
        Assertions.assertFalse((boolean)verifications.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void inlineSignThenDetachNoArmorThenArmorThenDetachedVerifyTest(SOP sop) throws IOException {
        byte[] message = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).data(message).getBytes();
        ByteArrayAndResult bytesAndResult = sop.inlineDetach().noArmor().message(inlineSigned).toByteArrayAndResult();
        byte[] plaintext = bytesAndResult.getBytes();
        Assertions.assertArrayEquals((byte[])message, (byte[])plaintext);
        byte[] signatures = ((Signatures)bytesAndResult.getResult()).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(signatures, TestData.BEGIN_PGP_SIGNATURE));
        byte[] armored = sop.armor().data(signatures).getBytes();
        JUtils.assertArrayStartsWith(armored, TestData.BEGIN_PGP_SIGNATURE);
        List verifications = ((DetachedVerify)sop.detachedVerify().cert("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxjMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u13NJkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+wpAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gLO\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHwngEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=QX3Q\n-----END PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8))).signatures(armored).data(plaintext);
        Assertions.assertFalse((boolean)verifications.isEmpty());
    }
}

