/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.testsuite.operation.AbstractSOPTest;

public class ListProfilesTest
extends AbstractSOPTest {
    static Stream<Arguments> provideInstances() {
        return ListProfilesTest.provideBackends();
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void listGenerateKeyProfiles(SOP sop) {
        List profiles = sop.listProfiles().generateKey();
        Assertions.assertFalse((boolean)profiles.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void listEncryptProfiles(SOP sop) {
        List profiles = sop.listProfiles().encrypt();
        Assertions.assertFalse((boolean)profiles.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void listUnsupportedProfiles(SOP sop) {
        Assertions.assertThrows(SOPGPException.UnsupportedProfile.class, () -> sop.listProfiles().subcommand("invalid"));
    }
}

