/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.operation.InlineSign;
import sop.operation.InlineVerify;
import sop.testsuite.JUtils;
import sop.testsuite.TestData;
import sop.testsuite.assertions.VerificationListAssert;
import sop.testsuite.operation.AbstractSOPTest;
import sop.util.UTF8Util;

@EnabledIf(value="sop.testsuite.operation.AbstractSOPTest#hasBackends")
public class RevokeKeyTest
extends AbstractSOPTest {
    static Stream<Arguments> provideInstances() {
        return RevokeKeyTest.provideBackends();
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeUnprotectedKey(SOP sop) throws IOException {
        byte[] secretKey = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] revocation = sop.revokeKey().keys(secretKey).getBytes();
        Assertions.assertTrue((boolean)JUtils.arrayStartsWith(revocation, TestData.BEGIN_PGP_PUBLIC_KEY_BLOCK));
        Assertions.assertFalse((boolean)Arrays.equals(secretKey, revocation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeUnprotectedKeyNoArmor(SOP sop) throws IOException {
        byte[] secretKey = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] revocation = sop.revokeKey().noArmor().keys(secretKey).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(revocation, TestData.BEGIN_PGP_PUBLIC_KEY_BLOCK));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeUnprotectedKeyUnarmored(SOP sop) throws IOException {
        byte[] secretKey = sop.generateKey().userId("Alice <alice@pgpainless.org>").noArmor().generate().getBytes();
        byte[] revocation = sop.revokeKey().noArmor().keys(secretKey).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(revocation, TestData.BEGIN_PGP_PUBLIC_KEY_BLOCK));
        Assertions.assertFalse((boolean)Arrays.equals(secretKey, revocation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeCertificateFails(SOP sop) throws IOException {
        byte[] secretKey = sop.generateKey().generate().getBytes();
        byte[] certificate = sop.extractCert().key(secretKey).getBytes();
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.revokeKey().keys(certificate).getBytes());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeProtectedKey(SOP sop) throws IOException {
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] secretKey = sop.generateKey().withKeyPassword(password).userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] revocation = sop.revokeKey().withKeyPassword(password).keys(secretKey).getBytes();
        Assertions.assertFalse((boolean)Arrays.equals(secretKey, revocation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeProtectedKeyWithMultiplePasswordOptions(SOP sop) throws IOException {
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] wrongPassword = "0r4ng3".getBytes(UTF8Util.UTF8);
        byte[] secretKey = sop.generateKey().withKeyPassword(password).userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] revocation = sop.revokeKey().withKeyPassword(wrongPassword).withKeyPassword(password).keys(secretKey).getBytes();
        Assertions.assertFalse((boolean)Arrays.equals(secretKey, revocation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeProtectedKeyWithMissingPassphraseFails(SOP sop) throws IOException {
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        byte[] secretKey = sop.generateKey().withKeyPassword(password).userId("Alice <alice@pgpainless.org>").generate().getBytes();
        Assertions.assertThrows(SOPGPException.KeyIsProtected.class, () -> sop.revokeKey().keys(secretKey).getBytes());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeProtectedKeyWithWrongPassphraseFails(SOP sop) throws IOException {
        byte[] password = "sw0rdf1sh".getBytes(UTF8Util.UTF8);
        String wrongPassword = "or4ng3";
        byte[] secretKey = sop.generateKey().withKeyPassword(password).userId("Alice <alice@pgpainless.org>").generate().getBytes();
        Assertions.assertThrows(SOPGPException.KeyIsProtected.class, () -> sop.revokeKey().withKeyPassword(wrongPassword).keys(secretKey).getBytes());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeKeyIsNowHardRevoked(SOP sop) throws IOException {
        byte[] key = sop.generateKey().generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] msg = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
        byte[] signedMsg = ((InlineSign)sop.inlineSign().key(key)).data(msg).getBytes();
        List result = (List)((InlineVerify)sop.inlineVerify().cert(cert)).data(signedMsg).toByteArrayAndResult().getResult();
        VerificationListAssert.assertThatVerificationList(result).hasSingleItem();
        byte[] revokedCert = sop.revokeKey().keys(key).getBytes();
        Assertions.assertThrows(SOPGPException.NoSignature.class, () -> ((InlineVerify)sop.inlineVerify().cert(revokedCert)).data(signedMsg).toByteArrayAndResult());
    }
}

