/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.operation;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.TestAbortedException;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.testsuite.operation.AbstractSOPTest;

@EnabledIf(value="sop.testsuite.operation.AbstractSOPTest#hasBackends")
public class VersionTest
extends AbstractSOPTest {
    static Stream<Arguments> provideInstances() {
        return VersionTest.provideBackends();
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void versionNameTest(SOP sop) {
        String name = sop.version().getName();
        Assertions.assertNotNull((Object)name);
        Assertions.assertFalse((boolean)name.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void versionVersionTest(SOP sop) {
        String version = sop.version().getVersion();
        Assertions.assertFalse((boolean)version.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void backendVersionTest(SOP sop) {
        String backend = sop.version().getBackendVersion();
        Assertions.assertFalse((boolean)backend.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void extendedVersionTest(SOP sop) {
        String extended = sop.version().getExtendedVersion();
        Assertions.assertFalse((boolean)extended.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void sopSpecVersionTest(SOP sop) {
        try {
            sop.version().getSopSpecVersion();
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("SOP backend does not support 'version --sop-spec' yet.");
        }
        String sopSpec = sop.version().getSopSpecVersion();
        if (sop.version().isSopSpecImplementationIncomplete()) {
            Assertions.assertTrue((boolean)sopSpec.startsWith("~draft-dkg-openpgp-stateless-cli-"));
        } else {
            Assertions.assertTrue((boolean)sopSpec.startsWith("draft-dkg-openpgp-stateless-cli-"));
        }
        int sopRevision = sop.version().getSopSpecRevisionNumber();
        Assertions.assertTrue((boolean)sop.version().getSopSpecRevisionName().endsWith("" + sopRevision));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void sopVVersionTest(SOP sop) {
        try {
            sop.version().getSopVVersion();
        }
        catch (SOPGPException.UnsupportedOption e) {
            throw new TestAbortedException("Implementation does (gracefully) not provide coverage for any sopv interface version.");
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("Implementation does not provide coverage for any sopv interface version.");
        }
    }
}

