/*
 * Decompiled with CFR 0.152.
 */
package sop.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.exception.SOPGPException;
import sop.util.UTF8Util;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0002\u001a\u00020\u0005H&J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0002\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005H&J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006H&J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lsop/operation/Decrypt;", "", "ciphertext", "Lsop/ReadyWithResult;", "Lsop/DecryptionResult;", "Ljava/io/InputStream;", "", "verifyNotAfter", "timestamp", "Ljava/util/Date;", "verifyNotBefore", "verifyWithCert", "cert", "withKey", "key", "withKeyPassword", "password", "", "withPassword", "withSessionKey", "sessionKey", "Lsop/SessionKey;", "sop-java"})
public interface Decrypt {
    @NotNull
    public Decrypt verifyNotBefore(@NotNull Date var1) throws SOPGPException.UnsupportedOption;

    @NotNull
    public Decrypt verifyNotAfter(@NotNull Date var1) throws SOPGPException.UnsupportedOption;

    @NotNull
    public Decrypt verifyWithCert(@NotNull InputStream var1) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException;

    @NotNull
    default public Decrypt verifyWithCert(@NotNull byte[] cert) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        return this.verifyWithCert(new ByteArrayInputStream(cert));
    }

    @NotNull
    public Decrypt withSessionKey(@NotNull SessionKey var1) throws SOPGPException.UnsupportedOption;

    @NotNull
    public Decrypt withPassword(@NotNull String var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    @NotNull
    public Decrypt withKey(@NotNull InputStream var1) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException;

    @NotNull
    default public Decrypt withKey(@NotNull byte[] key) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.withKey(new ByteArrayInputStream(key));
    }

    @NotNull
    default public Decrypt withKeyPassword(@NotNull String password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        byte[] byArray = password.getBytes(UTF8Util.UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.withKeyPassword(byArray);
    }

    @NotNull
    public Decrypt withKeyPassword(@NotNull byte[] var1) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable;

    @NotNull
    public ReadyWithResult<DecryptionResult> ciphertext(@NotNull InputStream var1) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException;

    @NotNull
    default public ReadyWithResult<DecryptionResult> ciphertext(@NotNull byte[] ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException {
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return this.ciphertext(new ByteArrayInputStream(ciphertext));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static Decrypt verifyWithCert(@NotNull Decrypt $this, @NotNull byte[] cert) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return $this.verifyWithCert(cert);
        }

        @Deprecated
        @NotNull
        public static Decrypt withKey(@NotNull Decrypt $this, @NotNull byte[] key) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.withKey(key);
        }

        @Deprecated
        @NotNull
        public static Decrypt withKeyPassword(@NotNull Decrypt $this, @NotNull String password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return $this.withKeyPassword(password);
        }

        @Deprecated
        @NotNull
        public static ReadyWithResult<DecryptionResult> ciphertext(@NotNull Decrypt $this, @NotNull byte[] ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException {
            Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
            return $this.ciphertext(ciphertext);
        }
    }
}

