/*
 * Decompiled with CFR 0.152.
 */
package sop;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sop.util.HexUtil;

public class SessionKey {
    private static final Pattern PATTERN = Pattern.compile("^(\\d):([0-9a-fA-F]+)$");
    private final byte algorithm;
    private final byte[] sessionKey;

    public SessionKey(byte algorithm, byte[] sessionKey) {
        this.algorithm = algorithm;
        this.sessionKey = sessionKey;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        return this.sessionKey;
    }

    public int hashCode() {
        return this.getAlgorithm() * 17 + Arrays.hashCode(this.getKey());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionKey)) {
            return false;
        }
        SessionKey otherKey = (SessionKey)other;
        return this.getAlgorithm() == otherKey.getAlgorithm() && Arrays.equals(this.getKey(), otherKey.getKey());
    }

    public static SessionKey fromString(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Provided session key does not match expected format.");
        }
        byte algorithm = Byte.parseByte(matcher.group(1));
        String key = matcher.group(2);
        return new SessionKey(algorithm, HexUtil.hexToBytes(key));
    }

    public String toString() {
        return "" + this.getAlgorithm() + ':' + HexUtil.bytesToHex(this.sessionKey);
    }
}

