/*
 * Decompiled with CFR 0.152.
 */
package sop.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sop.EncryptionResult;
import sop.Profile;
import sop.ReadyWithResult;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0000H&J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\bH&J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\bH&J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bH&J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tH&J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\fH&\u00a8\u0006\u0015\u00c0\u0006\u0003"}, d2={"Lsop/operation/Encrypt;", "", "mode", "Lsop/enums/EncryptAs;", "noArmor", "plaintext", "Lsop/ReadyWithResult;", "Lsop/EncryptionResult;", "Ljava/io/InputStream;", "", "profile", "profileName", "", "Lsop/Profile;", "signWith", "key", "withCert", "cert", "withKeyPassword", "password", "withPassword", "sop-java"})
public interface Encrypt {
    @NotNull
    public Encrypt noArmor();

    @NotNull
    public Encrypt mode(@NotNull EncryptAs var1) throws SOPGPException.UnsupportedOption;

    @NotNull
    public Encrypt signWith(@NotNull InputStream var1) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException;

    @NotNull
    default public Encrypt signWith(@NotNull byte[] key) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.signWith(new ByteArrayInputStream(key));
    }

    @NotNull
    default public Encrypt withKeyPassword(@NotNull String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        byte[] byArray = password.getBytes(UTF8Util.UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.withKeyPassword(byArray);
    }

    @NotNull
    public Encrypt withKeyPassword(@NotNull byte[] var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    @NotNull
    public Encrypt withPassword(@NotNull String var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    @NotNull
    public Encrypt withCert(@NotNull InputStream var1) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException;

    @NotNull
    default public Encrypt withCert(@NotNull byte[] cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        return this.withCert(new ByteArrayInputStream(cert));
    }

    @NotNull
    default public Encrypt profile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.profile(profile.getName());
    }

    @NotNull
    public Encrypt profile(@NotNull String var1);

    @NotNull
    public ReadyWithResult<EncryptionResult> plaintext(@NotNull InputStream var1) throws IOException, SOPGPException.KeyIsProtected;

    @NotNull
    default public ReadyWithResult<EncryptionResult> plaintext(@NotNull byte[] plaintext) throws IOException, SOPGPException.KeyIsProtected {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return this.plaintext(new ByteArrayInputStream(plaintext));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static Encrypt signWith(@NotNull Encrypt $this, @NotNull byte[] key) throws SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.signWith(key);
        }

        @Deprecated
        @NotNull
        public static Encrypt withKeyPassword(@NotNull Encrypt $this, @NotNull String password) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return $this.withKeyPassword(password);
        }

        @Deprecated
        @NotNull
        public static Encrypt withCert(@NotNull Encrypt $this, @NotNull byte[] cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData, IOException {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return $this.withCert(cert);
        }

        @Deprecated
        @NotNull
        public static Encrypt profile(@NotNull Encrypt $this, @NotNull Profile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            return $this.profile(profile);
        }

        @Deprecated
        @NotNull
        public static ReadyWithResult<EncryptionResult> plaintext(@NotNull Encrypt $this, @NotNull byte[] plaintext) throws IOException, SOPGPException.KeyIsProtected {
            Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
            return $this.plaintext(plaintext);
        }
    }
}

