/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.comparator;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pharmgkb.common.comparator.AbstractComparator;
import org.pharmgkb.common.comparator.SortOrder;

public class CollectionComparator
extends AbstractComparator<Collection<? extends Comparable>> {
    private static final Comparator<Collection<? extends Comparable>> sf_comparator = new CollectionComparator();

    public static Comparator<Collection<? extends Comparable>> getComparator() {
        return sf_comparator;
    }

    public CollectionComparator() {
    }

    public CollectionComparator(SortOrder order) {
        this.setOrder(order);
    }

    @Override
    public int compare(@Nullable Collection<? extends Comparable> a, @Nullable Collection<? extends Comparable> b) {
        int rez;
        int aSize = 0;
        if (a != null) {
            aSize = a.size();
        }
        int bSize = 0;
        if (b != null) {
            bSize = b.size();
        }
        if ((rez = Integer.compare(aSize, bSize)) != 0) {
            return this.modReturn(rez);
        }
        if (aSize == 0) {
            return 0;
        }
        Iterator<? extends Comparable> aIt = a.iterator();
        Iterator<? extends Comparable> bIt = b.iterator();
        while (aIt.hasNext()) {
            rez = aIt.next().compareTo(bIt.next());
            if (rez == 0) continue;
            return this.modReturn(rez);
        }
        return 0;
    }
}

