/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.comparator;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HaplotypeNameComparator
implements Comparator<String> {
    private static final Pattern sf_strictStarPattern = Pattern.compile("(.*)\\*(\\d+)(.*)");
    private static final Pattern sf_looseStarPattern = Pattern.compile("(\\D*)(\\d+)(.*)");
    private static final Comparator<String> sf_comparator = new HaplotypeNameComparator();
    private static final List<String> sf_topTerms = ImmutableList.of((Object)"Any", (Object)"All");
    private static final List<String> sf_bottomTerms = ImmutableList.of((Object)"Other", (Object)"Unknown");

    public static Comparator<String> getComparator() {
        return sf_comparator;
    }

    @Override
    public int compare(String name1, String name2) {
        if (name1 == name2) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        if (sf_topTerms.contains(name1) || sf_bottomTerms.contains(name2)) {
            return -1;
        }
        if (sf_topTerms.contains(name2) || sf_bottomTerms.contains(name1)) {
            return 1;
        }
        Matcher matcher1 = sf_strictStarPattern.matcher(name1);
        Matcher matcher2 = sf_strictStarPattern.matcher(name2);
        if (matcher1.matches() && matcher2.matches()) {
            return this.compareMatchers(matcher1, matcher2);
        }
        matcher1 = sf_looseStarPattern.matcher(name1);
        matcher2 = sf_looseStarPattern.matcher(name2);
        if (matcher1.matches() && matcher2.matches()) {
            return this.compareMatchers(matcher1, matcher2);
        }
        return ObjectUtils.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
    }

    private int compareMatchers(Matcher matcher1, Matcher matcher2) {
        String prePortion2;
        String prePortion1 = StringUtils.trimToNull((String)matcher1.group(1));
        int rez = ObjectUtils.compare((Comparable)((Object)prePortion1), (Comparable)((Object)(prePortion2 = StringUtils.trimToNull((String)matcher2.group(1)))));
        if (rez != 0) {
            return rez;
        }
        String starPortion1 = matcher1.group(2);
        String starPortion2 = matcher2.group(2);
        int star1 = Integer.parseInt(starPortion1);
        int star2 = Integer.parseInt(starPortion2);
        rez = ObjectUtils.compare((Comparable)Integer.valueOf(star1), (Comparable)Integer.valueOf(star2));
        if (rez != 0) {
            return rez;
        }
        String restPortion1 = StringUtils.trimToNull((String)matcher1.group(3));
        String restPortion2 = StringUtils.trimToNull((String)matcher2.group(3));
        return ObjectUtils.compare((Comparable)((Object)restPortion1), (Comparable)((Object)restPortion2));
    }
}

