/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pharmgkb.common.util.ExtendedEnum;
import org.pharmgkb.common.util.ExtendedEnumHelper;

public class ExtendedEnumConverter
implements Converter {
    private static final ExtendedEnumConverter sf_converter = new ExtendedEnumConverter();

    public static ExtendedEnumConverter getConverter() {
        return sf_converter;
    }

    public <T> @Nullable T convert(Class<T> aClass, Object o) {
        if (o == null) {
            return null;
        }
        if (ExtendedEnum.class.isAssignableFrom(aClass)) {
            ExtendedEnumHelper<T> helper = ExtendedEnumHelper.getExtendedEnumHelper(aClass);
            if (o instanceof String) {
                return aClass.cast(helper.fromString((String)o));
            }
            if (o instanceof Number) {
                return aClass.cast(helper.lookupById(((Number)o).intValue()));
            }
            throw new ConversionException("Don't know how to translate " + o.getClass() + " to " + aClass);
        }
        throw new ConversionException("Don't know how to convert to " + aClass);
    }
}

