/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pharmgkb.common.util.ExtendedEnum;
import org.pharmgkb.common.util.ExtendedEnumConverter;

public class ExtendedEnumHelper<T extends ExtendedEnum> {
    private static final Map<Class, ExtendedEnumHelper> sf_enumMap = new HashMap<Class, ExtendedEnumHelper>();
    private final Class m_enumClass;
    private final Map<Integer, T> m_idMap = new TreeMap<Integer, T>();
    private final Map<String, T> m_shortNameMap = new TreeMap<String, T>();
    private final Map<String, T> m_displayNameMap = new TreeMap<String, T>();
    private final Map<String, T> m_lcNameMap = new TreeMap<String, T>();
    private final Map<String, T> m_additionalNamesMap = new TreeMap<String, T>();
    private static final Pattern sf_punctuationPattern = Pattern.compile("\\p{Punct}");

    public ExtendedEnumHelper(Class clz) {
        Preconditions.checkNotNull((Object)clz, (Object)"clz is null");
        this.m_enumClass = clz;
        ConvertUtils.register((Converter)ExtendedEnumConverter.getConverter(), (Class)clz);
    }

    public void add(T theEnum, int id, String shortName, @Nullable String displayName, String ... additionalNames) {
        Preconditions.checkArgument((!this.m_idMap.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate ID '%s' for %s", (int)id, (Object)theEnum.getClass().getSimpleName());
        Preconditions.checkNotNull((Object)shortName, (Object)"shortName is null");
        String strippedShortName = StringUtils.stripToNull((String)shortName);
        Preconditions.checkArgument((strippedShortName != null ? 1 : 0) != 0, (String)"Empty shortName for %s", (Object)theEnum.getClass().getSimpleName());
        Preconditions.checkArgument((!strippedShortName.contains(" ") ? 1 : 0) != 0, (String)"Spaces in shortName for %s", (Object)theEnum.getClass().getSimpleName());
        Preconditions.checkArgument((!StringUtils.isNumeric((CharSequence)strippedShortName) ? 1 : 0) != 0, (String)"Numeric shortName for %s", (Object)theEnum.getClass().getSimpleName());
        Preconditions.checkArgument((!this.m_shortNameMap.containsKey(strippedShortName) ? 1 : 0) != 0, (String)"Duplicate shortName '%s' for %s", (Object)strippedShortName, (Object)theEnum.getClass().getSimpleName());
        String strippedDisplayName = StringUtils.stripToNull((String)displayName);
        if (strippedDisplayName != null) {
            Preconditions.checkArgument((!this.m_displayNameMap.containsKey(strippedDisplayName) ? 1 : 0) != 0, (String)"Duplicate displayName '%s' for %s", (Object)strippedDisplayName, (Object)theEnum.getClass().getSimpleName());
        }
        this.m_idMap.put(id, theEnum);
        this.m_shortNameMap.put(strippedShortName, theEnum);
        this.m_lcNameMap.put(strippedShortName.toLowerCase(), theEnum);
        if (strippedDisplayName != null) {
            this.m_displayNameMap.put(strippedDisplayName, theEnum);
            this.m_lcNameMap.put(strippedDisplayName.toLowerCase(), theEnum);
        }
        if (!sf_enumMap.containsKey(theEnum.getClass())) {
            sf_enumMap.put(theEnum.getClass(), this);
        }
        if (additionalNames != null) {
            for (String additionalName : additionalNames) {
                if (additionalName == null) continue;
                this.m_additionalNamesMap.put(additionalName, theEnum);
                ExtendedEnum oldVal = (ExtendedEnum)this.m_lcNameMap.put(additionalName.toLowerCase(), theEnum);
                if (oldVal == null || oldVal == theEnum) continue;
                throw new IllegalArgumentException(String.format("Additional name '%s' for %s mapped to %s and %s", additionalName, theEnum.getClass().getSimpleName(), oldVal, theEnum));
            }
        }
    }

    public @Nullable T lookupById(int id) {
        return (T)((ExtendedEnum)this.m_idMap.get(id));
    }

    public @Nullable T lookupByName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        if (this.m_displayNameMap.containsKey(name)) {
            return (T)((ExtendedEnum)this.m_displayNameMap.get(name));
        }
        if (this.m_shortNameMap.containsKey(name)) {
            return (T)((ExtendedEnum)this.m_shortNameMap.get(name));
        }
        if (this.m_additionalNamesMap.containsKey(name)) {
            return (T)((ExtendedEnum)this.m_additionalNamesMap.get(name));
        }
        return (T)((ExtendedEnum)this.m_lcNameMap.get(name.toLowerCase()));
    }

    public T lookupByNameOrThrow(String name) {
        T rez = this.lookupByName(name);
        if (rez == null) {
            throw new IllegalArgumentException("No such " + this.m_enumClass.getSimpleName() + ": '" + name + "'");
        }
        return rez;
    }

    public @Nullable T fromString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)value)) {
            return this.lookupById(Integer.parseInt(value));
        }
        return this.lookupByName(value);
    }

    public Collection<T> getAllSortedById() {
        return this.m_idMap.values();
    }

    public Collection<T> getAllSortedByName() {
        if (this.m_displayNameMap.isEmpty()) {
            return this.m_shortNameMap.values();
        }
        return this.m_displayNameMap.values();
    }

    public static <T extends ExtendedEnum> ExtendedEnumHelper<T> getExtendedEnumHelper(Class<T> enumClass) {
        ExtendedEnumHelper extendedEnumHelper;
        Preconditions.checkNotNull(enumClass, (Object)"enumClass is null");
        if (!sf_enumMap.containsKey(enumClass)) {
            Field[] fields = enumClass.getFields();
            if (fields.length > 0) {
                try {
                    fields[0].get(enumClass);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Cannot access enums in class " + enumClass.getName(), ex);
                }
            } else {
                throw new IllegalStateException("No enumerations in class " + enumClass.getName());
            }
        }
        if ((extendedEnumHelper = sf_enumMap.get(enumClass)) == null) {
            throw new IllegalStateException("Unregistered ExtendedEnum: " + enumClass);
        }
        return extendedEnumHelper;
    }

    public static String camelCaseFormat(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        String strippedName = StringUtils.stripToNull((String)sf_punctuationPattern.matcher(name.toLowerCase()).replaceAll(""));
        if (strippedName == null) {
            throw new IllegalArgumentException("'" + name + "' converts to empty string");
        }
        return StringUtils.deleteWhitespace((String)StringUtils.uncapitalize((String)WordUtils.capitalize((String)strippedName)));
    }
}

