/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PathUtils {
    private PathUtils() {
    }

    public static String getFilename(Path file) {
        Preconditions.checkNotNull((Object)file);
        return file.getName(file.getNameCount() - 1).toString();
    }

    public static @Nullable String getFileExtension(Path file) {
        String filename = PathUtils.getFilename(file);
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        return StringUtils.stripToNull((String)filename.substring(idx + 1));
    }

    public static String getBaseFilename(Path file) {
        Preconditions.checkNotNull((Object)file);
        String fileName = PathUtils.getFilename(file);
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return fileName;
        }
        return fileName.substring(0, idx);
    }

    public static Path getPathToResource(String filename) {
        Preconditions.checkNotNull((Object)filename);
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        URL url = PathUtils.class.getClassLoader().getResource(filename);
        return PathUtils.getPath(url, filename);
    }

    public static Path getPathToResource(Class clz, String filename) {
        Preconditions.checkNotNull((Object)filename);
        URL url = clz.getResource(filename);
        return PathUtils.getPath(url, filename);
    }

    private static Path getPath(@Nullable URL url, String filename) {
        if (url == null) {
            throw new IllegalArgumentException("No such resource: " + filename);
        }
        try {
            URI uri = url.toURI();
            if (url.getProtocol().equalsIgnoreCase("jar")) {
                try {
                    FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException ex) {
                    try {
                        FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    catch (IOException ex2) {
                        throw new IllegalStateException("Unable to create zip/jar filesystem", ex2);
                    }
                }
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Filename '" + filename + "' translated to invalid URI (" + url + ")", ex);
        }
    }
}

