/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.pharmgkb.common.util.ZippedFileInputStream;

public class StreamUtils {
    private StreamUtils() {
    }

    public static InputStream openInputStream(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException("File does not exist");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException("Path does not lead to a regular file");
        }
        String origFilename = path.getFileName().toString();
        String filename = origFilename.toLowerCase();
        if (filename.endsWith(".gz")) {
            return new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]), 65536);
        }
        if (filename.endsWith(".zip")) {
            origFilename = origFilename.substring(0, origFilename.length() - 4);
            return new ZippedFileInputStream(Files.newInputStream(path, new OpenOption[0]), origFilename);
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static BufferedReader openReader(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException("File does not exist");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException("Path does not lead to a regular file");
        }
        String origFilename = path.getFileName().toString();
        String filename = origFilename.toLowerCase();
        if (filename.endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]), 65536)));
        }
        if (filename.endsWith(".zip")) {
            origFilename = origFilename.substring(0, origFilename.length() - 4);
            return new BufferedReader(new InputStreamReader(new ZippedFileInputStream(Files.newInputStream(path, new OpenOption[0]), origFilename)));
        }
        return Files.newBufferedReader(path);
    }

    public static void copyUrlToFile(String url, Path file) throws IOException {
        block39: {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                try (CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
                    HttpGet httpget = new HttpGet(url);
                    try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
                        try (InputStream in = response.getEntity().getContent();
                             OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        if (response.getStatusLine().getStatusCode() != 200) {
                            throw new IOException("Error downloading " + url + ": " + response.getStatusLine());
                        }
                        break block39;
                    }
                }
            }
            URL ftpUrl = new URL(url);
            URLConnection conn = ftpUrl.openConnection();
            try (InputStream in = conn.getInputStream();
                 OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }
}

