/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttler {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final long m_minTime;
    private long m_lastScheduledAction = System.currentTimeMillis();

    public Throttler(long minTime, TimeUnit unit) {
        Preconditions.checkArgument((minTime > 0L ? 1 : 0) != 0);
        this.m_minTime = unit.toMillis(minTime);
        Preconditions.checkArgument((this.m_minTime > 0L ? 1 : 0) != 0, (Object)"Minimum time must be greater than 0 milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Throttler throttler = this;
        synchronized (throttler) {
            this.m_lastScheduledAction = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        Throttler throttler = this;
        synchronized (throttler) {
            long curTime = System.currentTimeMillis();
            long timeLeft = this.m_lastScheduledAction + this.m_minTime - curTime;
            if (timeLeft > 0L) {
                try {
                    sf_logger.debug("Throttling for {}ms", (Object)timeLeft);
                    Thread.sleep(timeLeft);
                }
                catch (InterruptedException ex) {
                    sf_logger.warn("Thread interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            this.m_lastScheduledAction = System.currentTimeMillis();
        }
    }
}

