/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private static final DateTimeFormatter sf_mediumDateFormatter = DateTimeFormatter.ofPattern("M/d/yyyy");
    private static final DateTimeFormatter sf_shortDateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter sf_longDateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter sf_simpleDateTimeFormatter = DateTimeFormatter.ofPattern("M/d/yy h:mm a z").withZone(ZoneId.systemDefault());

    public static String humanReadableDate(Date date) {
        return TimeUtils.humanReadableDate(date.toInstant());
    }

    public static String humanReadableDate(TemporalAccessor time) {
        return sf_shortDateFormatter.format(time);
    }

    public static Date parseToDate(String time) throws DateTimeParseException {
        TemporalAccessor temporalAccessor;
        try {
            temporalAccessor = sf_shortDateFormatter.parse(time);
        }
        catch (DateTimeParseException ex) {
            try {
                temporalAccessor = sf_mediumDateFormatter.parse(time);
            }
            catch (DateTimeParseException ex2) {
                temporalAccessor = sf_longDateFormatter.parse(time);
            }
        }
        LocalDate ld = LocalDate.from(temporalAccessor);
        return Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static String humanReadableDateTime(Date date) {
        return TimeUtils.humanReadableDateTime(date.toInstant());
    }

    public static String humanReadableDateTime(TemporalAccessor time) {
        return sf_simpleDateTimeFormatter.format(time);
    }

    public static String humanReadableDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() - TimeUnit.DAYS.toHours(duration.toDays());
        long mins = duration.toMinutes() - TimeUnit.HOURS.toMinutes(duration.toHours());
        long secs = duration.getSeconds() - TimeUnit.MINUTES.toSeconds(duration.toMinutes());
        StringBuilder stringBuilder = new StringBuilder();
        boolean hasAnd = false;
        if (secs > 0L) {
            TimeUtils.prependDuration(stringBuilder, secs, "second", "seconds");
        }
        if (mins > 0L) {
            hasAnd = TimeUtils.addCommas(stringBuilder, false);
            TimeUtils.prependDuration(stringBuilder, mins, "minute", "minutes");
        }
        if (hours > 0L) {
            hasAnd = TimeUtils.addCommas(stringBuilder, hasAnd);
            TimeUtils.prependDuration(stringBuilder, hours, "hour", "hours");
        }
        if (days > 0L) {
            TimeUtils.addCommas(stringBuilder, hasAnd);
            TimeUtils.prependDuration(stringBuilder, days, "day", "days");
        }
        return stringBuilder.toString();
    }

    public static String humanReadablePreciseDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() - TimeUnit.DAYS.toHours(duration.toDays());
        long mins = duration.toMinutes() - TimeUnit.HOURS.toMinutes(duration.toHours());
        long secs = duration.getSeconds() - TimeUnit.MINUTES.toSeconds(duration.toMinutes());
        long ms = TimeUnit.NANOSECONDS.toMillis(duration.getNano());
        StringBuilder stringBuilder = new StringBuilder();
        boolean hasAnd = false;
        if (ms > 0L && mins == 0L && hours == 0L && days == 0L) {
            TimeUtils.prependDuration(stringBuilder, ms, "ms", "ms");
        }
        if (secs > 0L) {
            hasAnd = TimeUtils.addCommas(stringBuilder, false);
            TimeUtils.prependDuration(stringBuilder, secs, "second", "seconds");
        }
        if (mins > 0L) {
            hasAnd = TimeUtils.addCommas(stringBuilder, false);
            TimeUtils.prependDuration(stringBuilder, mins, "minute", "minutes");
        }
        if (hours > 0L) {
            hasAnd = TimeUtils.addCommas(stringBuilder, hasAnd);
            TimeUtils.prependDuration(stringBuilder, hours, "hour", "hours");
        }
        if (days > 0L) {
            TimeUtils.addCommas(stringBuilder, hasAnd);
            TimeUtils.prependDuration(stringBuilder, days, "day", "days");
        }
        return stringBuilder.toString();
    }

    private static boolean addCommas(StringBuilder stringBuilder, boolean hasAnd) {
        if (stringBuilder.length() > 0) {
            if (hasAnd) {
                stringBuilder.insert(0, ", ");
            } else {
                stringBuilder.insert(0, " and ");
                hasAnd = true;
            }
        }
        return hasAnd;
    }

    private static void prependDuration(StringBuilder stringBuilder, long duration, String singular, String plural) {
        String period = duration > 1L ? plural : singular;
        stringBuilder.insert(0, period).insert(0, " ").insert(0, duration);
    }
}

