/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtils {
    private static final Set<String> sf_webSchemes = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final Set<String> sf_urlSchemes = Sets.newHashSet((Object[])new String[]{"http", "https", "ftp"});
    private static final Pattern sf_172Pattern = Pattern.compile("^172\\.(\\d+)\\.\\d+\\.\\d+$");
    private static final int sf_timeout = 1000;

    private UrlUtils() {
    }

    public static boolean isValidWebUrl(String urlString) {
        return UrlUtils.isValid(urlString, true, false, false, false);
    }

    public static boolean isValid(String urlString) {
        return UrlUtils.isValid(urlString, false, false, false, false);
    }

    public static boolean isValid(String urlString, boolean noFtp, boolean allowLocalhost, boolean allowPrivateIp, boolean verify) {
        try {
            Set<String> schemes;
            URL url = new URL(urlString);
            URI uri = url.toURI();
            Set<String> set = schemes = noFtp ? sf_webSchemes : sf_urlSchemes;
            if (!schemes.contains(uri.getScheme())) {
                return false;
            }
            if (uri.getHost() == null) {
                return false;
            }
            if (uri.getRawUserInfo() != null && Splitter.on((String)":").splitToList((CharSequence)uri.getRawUserInfo()).size() > 2) {
                return false;
            }
            if (!allowLocalhost && (uri.getHost().equals("localhost") || uri.getHost().startsWith("localhost."))) {
                return false;
            }
            if (!allowPrivateIp) {
                if (uri.getHost().startsWith("[fd") || uri.getHost().equals("127.0.0.1") || uri.getHost().startsWith("10.") || uri.getHost().startsWith("192.168.")) {
                    return false;
                }
                Matcher m = sf_172Pattern.matcher(uri.getHost());
                if (m.matches() && Integer.parseInt(m.group(1)) >= 16 && Integer.parseInt(m.group(1)) <= 32) {
                    return false;
                }
            }
            if (verify) {
                return UrlUtils.isReachable(url);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReachable(URL url) {
        try {
            if (sf_webSchemes.contains(url.getProtocol())) {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(1000);
                connection.setRequestMethod("HEAD");
                connection.setRequestProperty("Accept-Encoding", "");
                int responseCode = connection.getResponseCode();
                return 200 <= responseCode && responseCode <= 399;
            }
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            connection.connect();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

