/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.pharmgkb.parser.vcf.model.FormatType;
import org.pharmgkb.parser.vcf.model.InfoType;
import org.pharmgkb.parser.vcf.model.ReservedProperty;

public class VcfUtils {
    private static final String sf_simpleAltPattern = "(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)";
    private static final String sf_number = "(?:(?:\\d+|(?:<.+>))(?::\\d+)?)";
    private static final Pattern sf_breakpointAltPattern = Pattern.compile("(?:\\.?(?:(?:(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)?\\[(?:(?:\\d+|(?:<.+>))(?::\\d+)?)\\[)|(?:(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)?\\](?:(?:\\d+|(?:<.+>))(?::\\d+)?)\\])|(?:\\](?:(?:\\d+|(?:<.+>))(?::\\d+)?)\\](?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)?)|(?:\\[(?:(?:\\d+|(?:<.+>))(?::\\d+)?)\\[(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)?))\\.?)");
    public static final Pattern ALT_BASE_PATTERN = Pattern.compile("\\.|(?:\\.?(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*))|(?:(?:(?:(?:[AaCcGgTtNn]+)|(?:<.+>))+|\\*)\\.?)|" + sf_breakpointAltPattern);
    public static final Pattern REF_BASE_PATTERN = Pattern.compile("[AaCcGgTtNn]+");
    public static final Pattern METADATA_PATTERN = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    public static final Pattern FORMAT_PATTERN = Pattern.compile("^[A-Za-z_][0-9A-Za-z_.]*$");
    public static final Pattern RSID_PATTERN = Pattern.compile("rs\\d+");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("(?:\\d+|[ARG\\.])");
    public static final Pattern FILE_FORMAT_PATTERN = Pattern.compile("VCFv[\\d\\.]+");
    public static final Pattern UNQUOTED_EQUAL_SIGN_PATTERN = Pattern.compile("=(?=([^\"]*\"[^\"]*\")*[^\"]*$)");

    @Nonnull
    public static Map<String, String> extractPropertiesFromLine(@Nonnull String value) {
        String unescapedValue = value.replaceAll("\\\\", "~~~~");
        boolean wasEscaped = !(unescapedValue = unescapedValue.replaceAll("\\\\\"", "~!~!")).equals(value);
        String[] cols = METADATA_PATTERN.split(unescapedValue);
        if (wasEscaped) {
            for (int x = 0; x < cols.length; ++x) {
                cols[x] = cols[x].replaceAll("~~~~", "\\");
                cols[x] = cols[x].replaceAll("~!~!", "\"");
            }
        }
        return VcfUtils.extractProperties(cols);
    }

    @Nonnull
    public static Map<String, String> extractProperties(String ... props) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String prop : props) {
            Pair<String, String> pair;
            try {
                pair = VcfUtils.splitProperty(prop);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error parsing property \"" + prop + "\"", e);
            }
            map.put((String)pair.getKey(), (String)pair.getValue());
        }
        return map;
    }

    @Nonnull
    public static Pair<String, String> splitProperty(@Nonnull String prop) {
        String[] parts = UNQUOTED_EQUAL_SIGN_PATTERN.split(prop);
        if (parts.length != 2) {
            throw new RuntimeException("There were " + (parts.length - 1) + " equals signs for: " + prop);
        }
        return Pair.of((Object)parts[0], (Object)parts[1]);
    }

    @Nonnull
    public static String quote(@Nonnull String string) {
        return "\"" + string + "\"";
    }

    @Nonnull
    public static String unquote(@Nonnull String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Nullable
    public static <T> T convertProperty(@Nonnull ReservedProperty key, @Nullable String value) {
        return VcfUtils.convertProperty(key.getType(), value, key.isList());
    }

    @Nullable
    public static <T> T convertProperty(@Nonnull Class<?> clas, @Nullable String value, boolean isList) {
        if (value == null || ".".equals(value)) {
            return null;
        }
        if (!isList) {
            try {
                return (T)VcfUtils.convertElement(clas, value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Wrong type specified", e);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String part : value.split(",")) {
            list.add(VcfUtils.convertElement(clas, part));
        }
        try {
            return (T)list;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Wrong type specified", e);
        }
    }

    @Nullable
    public static <T> T convertProperty(@Nonnull FormatType type, @Nullable String value) {
        Class clas;
        switch (type) {
            case Integer: {
                clas = Long.class;
                break;
            }
            case Float: {
                clas = BigDecimal.class;
                break;
            }
            case Character: {
                clas = Character.class;
                break;
            }
            case String: {
                clas = String.class;
                break;
            }
            default: {
                throw new RuntimeException(FormatType.class.getSimpleName() + " " + (Object)((Object)type) + " isn't covered?!");
            }
        }
        return VcfUtils.convertProperty(clas, value, false);
    }

    @Nullable
    public static <T> T convertProperty(@Nonnull InfoType type, @Nullable String value) {
        Class clas;
        switch (type) {
            case Integer: {
                clas = Long.class;
                break;
            }
            case Float: {
                clas = BigDecimal.class;
                break;
            }
            case Character: {
                clas = Character.class;
                break;
            }
            case String: {
                clas = String.class;
                break;
            }
            case Flag: {
                clas = Boolean.class;
                break;
            }
            default: {
                throw new RuntimeException(InfoType.class.getSimpleName() + " " + (Object)((Object)type) + " isn't covered?!");
            }
        }
        return VcfUtils.convertProperty(clas, value, false);
    }

    @Nullable
    private static Object convertElement(@Nonnull Class<?> clas, @Nullable String value) {
        if (value == null || ".".equals(value)) {
            return null;
        }
        if (clas == String.class) {
            return value;
        }
        if (clas == Character.class) {
            if (value.length() == 1) {
                return value;
            }
            throw new IllegalArgumentException("Invalid character value '" + value + "'");
        }
        if (clas == Boolean.class) {
            if ((value = StringUtils.stripToNull((String)value)) == null) {
                return true;
            }
            if (value.equals("0") || value.equalsIgnoreCase("false")) {
                return false;
            }
            if (value.equals("1") || value.equalsIgnoreCase("true")) {
                return true;
            }
            throw new IllegalArgumentException("Invalid boolean value: '" + value + "'");
        }
        if (clas == BigDecimal.class) {
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected float; got " + value);
            }
        }
        if (clas == Long.class) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected integer; got " + value);
            }
        }
        throw new UnsupportedOperationException("Type " + clas + " unrecognized");
    }
}

