/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.FormatType;
import org.pharmgkb.parser.vcf.model.IdDescriptionMetadata;
import org.pharmgkb.parser.vcf.model.SpecialVcfNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatMetadata
extends IdDescriptionMetadata {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ID = "ID";
    public static final String DESCRIPTION = "Description";
    public static final String NUMBER = "Number";
    public static final String TYPE = "Type";
    private FormatType m_type;

    public FormatMetadata(@Nonnull String id, @Nonnull String description, @Nonnull String number, @Nonnull FormatType type) {
        super(id, description, false);
        this.putPropertyRaw(NUMBER, number);
        this.putPropertyRaw(TYPE, type.name());
        this.init();
    }

    public FormatMetadata(@Nonnull Map<String, String> properties) {
        super(properties, false);
        this.init();
    }

    public void init() {
        String number = this.getPropertyRaw(NUMBER);
        if (number == null) {
            sf_logger.warn("Required metadata property \"{}\" is missing", (Object)NUMBER);
        } else if (!VcfUtils.NUMBER_PATTERN.matcher(number).matches()) {
            sf_logger.warn("{} is not a VCF number: '{}'", (Object)NUMBER, (Object)number);
        }
        this.m_type = FormatType.valueOf(this.getPropertyRaw(TYPE));
        this.ensureNoExtras(ID, DESCRIPTION, NUMBER, TYPE);
    }

    @Nullable
    public String getNumber() {
        return this.getPropertyRaw(NUMBER);
    }

    @Nullable
    public SpecialVcfNumber getReservedNumber() {
        return SpecialVcfNumber.fromId(this.getPropertyRaw(NUMBER));
    }

    @Nullable
    public FormatType getType() {
        return this.m_type;
    }
}

