/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.model.ReservedProperty;

public enum ReservedFormatProperty implements ReservedProperty
{
    Genotype("GT", "Genotype, encoded as allele values separated by either / or |.", String.class, false, "1"),
    Depth("DP", "Read depth at this position for this sample.", Long.class, false, "1"),
    Filter("FT", "Sample genotype filter indicating if this genotype was called.", String.class, false),
    GenotypeLikelihoods("GL", "Genotype likelihoods comprised of comma separated floating point log10-scaled likelihoods for all possible genotypes given the set of alleles defined in the REF and ALT fields.", BigDecimal.class, true, "G"),
    GenotypeLikelihoodsOfHeterogenousPloidy("GLE", "genotype likelihoods of heterogeneous ploidy, used in presence of uncertain copy number.", String.class, true),
    PhredScaledGenotypeLikelihoods("PL", "the phred-scaled genotype likelihoods rounded to the closest integer(and otherwise defined precisely as the GL field)", Long.class, true, "G"),
    GenotypePosteriorProbabilitiesPhredScaled("GP", "The phred-scaled genotype posterior probabilities (and otherwise defined precisely as the GL field); intended to store imputed genotype probabilities", BigDecimal.class, true, "G"),
    GenotypeQualityConditional("GQ", "conditional genotype quality, encoded as a phred quality\u00e2\u02c6\u201910log10p(genotype call is wrong, conditioned on the site\u00e2\u20ac\u2122s being variant)", Long.class, false, "1"),
    HaplotypeQualities("HQ", "Haplotype qualities, two comma separated phred qualities", Long.class, true),
    PhaseSet("PS", "Phase set; see specification.", Long.class, false),
    PhasingQuality("PQ", "Phasing quality, the phred-scaled probability that alleles are ordered incorrectly in a heterozygote (against all other members in the phase set).", Long.class, false),
    ExpectedAlleleCounts("EC", "List of expected alternate allele counts for each alternate allele in the same order as listed in the ALT field (typically used in association analyses)", Long.class, true),
    MappingQuality("MQ", "RMS mapping quality, similar to the version in the INFO field.", Long.class, true),
    CopyNumber("CN", "Copy number genotype for imprecise events", Long.class, false, "1"),
    CopyNumberGenotypeQuality("CNQ", "Copy number genotype quality for imprecise events", BigDecimal.class, false, "1"),
    CopyNumberLikelihood("CNL", "Copy number genotype likelihood for imprecise events", BigDecimal.class, true, "."),
    PhredScoreForNovelty("NQ", "Phred style probability score that the variant is novel", BigDecimal.class, false, "1"),
    HaplotypeId("HAP", "Unique haplotype identifier", String.class, false, "1"),
    AncestralHaplotypeId("AHAP", "Unique identifier of ancestral haplotype", String.class, false, "1");

    @Nonnull
    private final String m_id;
    @Nonnull
    private final String m_description;
    @Nonnull
    private final Class m_type;
    private final boolean m_isList;
    @Nullable
    private final String m_number;

    private ReservedFormatProperty(@Nonnull String id, String description, Class type, boolean isList) {
        this(id, description, type, isList, null);
    }

    private ReservedFormatProperty(@Nonnull String id, String description, @Nullable Class type, boolean isList, String number) {
        this.m_id = id;
        this.m_description = description;
        this.m_type = type;
        this.m_isList = isList;
        this.m_number = number;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.m_id;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.m_description;
    }

    @Override
    @Nonnull
    public Class getType() {
        return this.m_type;
    }

    @Nullable
    public String getNumber() {
        return this.m_number;
    }

    @Override
    public boolean isList() {
        return this.m_isList;
    }
}

