/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.ReservedInfoProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcfPosition {
    private static final Logger sf_logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Joiner sf_commaJoiner = Joiner.on((String)",");
    private static final Pattern sf_whitespace = Pattern.compile(".*\\s.*");
    private String m_chromosome;
    private long m_position;
    private List<String> m_ids = new ArrayList<String>();
    private String m_refBases;
    private List<String> m_altBases = new ArrayList<String>();
    private List<String> m_alleles = new ArrayList<String>();
    private BigDecimal m_quality;
    private List<String> m_filter = new ArrayList<String>();
    private ListMultimap<String, String> m_info = ArrayListMultimap.create();
    private List<String> m_format = new ArrayList<String>();

    public VcfPosition(@Nonnull String chr, long pos, @Nullable List<String> ids, @Nonnull String ref, @Nullable List<String> altBases, @Nullable BigDecimal qual, @Nullable List<String> filter, @Nullable ListMultimap<String, String> info, @Nullable List<String> format) {
        if (sf_whitespace.matcher(chr).matches() || chr.contains(":")) {
            throw new IllegalArgumentException("CHROM column \"" + chr + "\" contains whitespace or colons");
        }
        if (ids != null) {
            for (String id : ids) {
                if (!sf_whitespace.matcher(id).matches() && !id.contains(";")) continue;
                throw new IllegalArgumentException("ID \"" + id + "\" contains whitespace or semicolons");
            }
        }
        if (!VcfUtils.REF_BASE_PATTERN.matcher(ref).matches()) {
            throw new IllegalArgumentException("Invalid reference base '" + ref + "' (must match " + VcfUtils.REF_BASE_PATTERN + ")");
        }
        if (altBases != null) {
            for (String base : altBases) {
                if (VcfUtils.ALT_BASE_PATTERN.matcher(base).matches()) continue;
                throw new IllegalArgumentException("Invalid alternate base '" + base + "' (must be [AaGgCcTtNn\\*]+ or <.+>)");
            }
        }
        if (filter != null) {
            for (String f : filter) {
                if (sf_whitespace.matcher(f).matches()) {
                    throw new IllegalArgumentException("FILTER column entry \"" + f + "\" contains whitespace");
                }
                if (f.equals("0")) {
                    throw new IllegalArgumentException("FILTER column entry should not be 0");
                }
                if (!f.equals("PASS")) continue;
                if (filter.size() == 1) {
                    sf_logger.warn("FILTER is PASS, but should have been passed as null. Converting to null");
                    filter = null;
                    break;
                }
                throw new IllegalArgumentException("FILTER contains PASS along with other filters!");
            }
        }
        if (info != null) {
            for (Map.Entry entry : info.entries()) {
                if (!sf_whitespace.matcher((CharSequence)entry.getKey()).matches() && !sf_whitespace.matcher((CharSequence)entry.getValue()).matches()) continue;
                throw new IllegalArgumentException("INFO column entry \"" + (String)entry.getKey() + "=" + (String)entry.getValue() + "\" contains whitespace");
            }
        }
        if (format != null) {
            for (String f : format) {
                if (VcfUtils.FORMAT_PATTERN.matcher(f).matches() && !f.contains(":")) continue;
                throw new IllegalArgumentException("FORMAT ID does not match VCF spec");
            }
        }
        this.m_chromosome = chr;
        this.m_position = pos;
        if (ids != null) {
            this.m_ids = ids;
        }
        this.m_refBases = ref;
        this.m_alleles.add(this.m_refBases);
        if (altBases != null) {
            this.m_altBases = altBases;
            this.m_alleles.addAll(altBases);
        }
        this.m_quality = qual;
        if (filter != null) {
            this.m_filter = filter;
        }
        if (info != null) {
            this.m_info = info;
        }
        if (format != null) {
            this.m_format = format;
        }
    }

    public VcfPosition(@Nonnull String chromosome, long position, @Nonnull String refBases, @Nonnull BigDecimal quality) {
        this.m_chromosome = chromosome;
        this.m_position = position;
        this.m_refBases = refBases;
        this.m_quality = quality;
    }

    @Nonnull
    public String getChromosome() {
        return this.m_chromosome;
    }

    public void setChromosome(@Nonnull String chromosome) {
        this.m_chromosome = chromosome;
    }

    public void setRef(@Nonnull String ref) {
        this.m_refBases = ref;
    }

    public long getPosition() {
        return this.m_position;
    }

    public void setPosition(long position) {
        this.m_position = position;
    }

    @Nonnull
    public List<String> getIds() {
        return this.m_ids;
    }

    @Nonnull
    public String getRef() {
        return this.m_refBases;
    }

    @Nonnull
    public List<String> getAltBases() {
        return this.m_altBases;
    }

    @Nonnull
    public String getAllele(int index) {
        return this.m_alleles.get(index);
    }

    @Nullable
    public BigDecimal getQuality() {
        return this.m_quality;
    }

    public void setQuality(@Nullable BigDecimal quality) {
        this.m_quality = quality;
    }

    public boolean isPassingAllFilters() {
        return this.m_filter.isEmpty();
    }

    @Nonnull
    public List<String> getFilters() {
        return this.m_filter;
    }

    @Nonnull
    public ListMultimap<String, String> getInfo() {
        return this.m_info;
    }

    @Nullable
    public List<String> getInfo(@Nonnull String id) {
        if (this.hasInfo(id)) {
            return this.m_info.get((Object)id);
        }
        return null;
    }

    @Nullable
    public <T> T getInfo(@Nonnull ReservedInfoProperty key) {
        if (!this.hasInfo(key.getId())) {
            return null;
        }
        List list = this.m_info.get((Object)key.getId());
        if (list.isEmpty()) {
            return null;
        }
        return VcfUtils.convertProperty(key, sf_commaJoiner.join((Iterable)list));
    }

    public boolean hasInfo(@Nonnull String id) {
        return this.m_info != null && this.m_info.containsKey((Object)id);
    }

    public boolean hasInfo(@Nonnull ReservedInfoProperty key) {
        return this.hasInfo(key.getId());
    }

    @Nonnull
    public List<String> getFormat() {
        return this.m_format;
    }

    @Nonnull
    public Set<String> getInfoKeys() {
        if (this.m_info == null) {
            return new HashSet<String>(0);
        }
        return this.m_info.keySet();
    }
}

