/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder;

import java.util.List;
import org.phenopackets.phenopackettools.core.PhenopacketToolsRuntimeException;
import org.phenopackets.schema.v2.Family;
import org.phenopackets.schema.v2.Phenopacket;
import org.phenopackets.schema.v2.core.File;
import org.phenopackets.schema.v2.core.MetaData;
import org.phenopackets.schema.v2.core.Pedigree;

public class FamilyBuilder {
    private final Family.Builder builder;

    private FamilyBuilder(String id) {
        this.builder = Family.newBuilder().setId(id);
    }

    public FamilyBuilder phenopacket(Phenopacket phenopacket) {
        this.builder.setProband(phenopacket);
        return this;
    }

    public FamilyBuilder relatives(List<Phenopacket> relativeList) {
        this.builder.addAllRelatives(relativeList);
        return this;
    }

    public FamilyBuilder pedigree(Pedigree pedigree) {
        this.builder.setPedigree(pedigree);
        return this;
    }

    public FamilyBuilder files(List<File> files) {
        this.builder.addAllFiles(files);
        return this;
    }

    public FamilyBuilder file(File file) {
        this.builder.addFiles(file);
        return this;
    }

    public FamilyBuilder metaData(MetaData metaData) {
        this.builder.setMetaData(metaData);
        return this;
    }

    public static FamilyBuilder create(String familyId) {
        return new FamilyBuilder(familyId);
    }

    public Family build() {
        if (!this.builder.hasMetaData()) {
            throw new PhenopacketToolsRuntimeException("MetaData element missing from Family");
        }
        if (!this.builder.hasPedigree()) {
            throw new PhenopacketToolsRuntimeException("Pedigree element missing from Family");
        }
        if (!this.builder.hasProband()) {
            throw new PhenopacketToolsRuntimeException("Proband Phenopacket element missing from Family");
        }
        return this.builder.build();
    }
}

