/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder;

import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.PhenotypicFeatureBuilder;
import org.phenopackets.schema.v2.Phenopacket;
import org.phenopackets.schema.v2.core.Biosample;
import org.phenopackets.schema.v2.core.Disease;
import org.phenopackets.schema.v2.core.File;
import org.phenopackets.schema.v2.core.Individual;
import org.phenopackets.schema.v2.core.Interpretation;
import org.phenopackets.schema.v2.core.Measurement;
import org.phenopackets.schema.v2.core.MedicalAction;
import org.phenopackets.schema.v2.core.MetaData;
import org.phenopackets.schema.v2.core.PhenotypicFeature;

public class PhenopacketBuilder {
    private final Phenopacket.Builder builder;

    private PhenopacketBuilder(String id, MetaData metaData) {
        this.builder = Phenopacket.newBuilder().setId(id).setMetaData(metaData);
    }

    public static PhenopacketBuilder create(String id, MetaData metaData) {
        return new PhenopacketBuilder(id, metaData);
    }

    public PhenopacketBuilder individual(Individual subject) {
        this.builder.setSubject(subject);
        return this;
    }

    public PhenopacketBuilder addPhenotypicFeature(String id, String label) {
        PhenotypicFeature phenotypicFeature = PhenotypicFeatureBuilder.of(id, label);
        return this.addPhenotypicFeature(phenotypicFeature);
    }

    public PhenopacketBuilder addPhenotypicFeature(PhenotypicFeature feature) {
        this.builder.addPhenotypicFeatures(feature);
        return this;
    }

    public PhenopacketBuilder addPhenotypicFeatures(List<PhenotypicFeature> features) {
        features.forEach(arg_0 -> ((Phenopacket.Builder)this.builder).addPhenotypicFeatures(arg_0));
        return this;
    }

    public PhenopacketBuilder addMeasurement(Measurement measurement) {
        this.builder.addMeasurements(measurement);
        return this;
    }

    public PhenopacketBuilder addMeasurements(List<Measurement> measurementList) {
        measurementList.forEach(arg_0 -> ((Phenopacket.Builder)this.builder).addMeasurements(arg_0));
        return this;
    }

    public PhenopacketBuilder addBiosample(Biosample biosample) {
        this.builder.addBiosamples(biosample);
        return this;
    }

    public PhenopacketBuilder addAllBiosamples(List<Biosample> biosampleList) {
        biosampleList.forEach(arg_0 -> ((Phenopacket.Builder)this.builder).addBiosamples(arg_0));
        return this;
    }

    public PhenopacketBuilder addInterpretation(Interpretation interpretation) {
        this.builder.addInterpretations(interpretation);
        return this;
    }

    public PhenopacketBuilder addDisease(Disease disease) {
        this.builder.addDiseases(disease);
        return this;
    }

    public PhenopacketBuilder addDiseases(List<Disease> diseaseList) {
        this.builder.addAllDiseases(diseaseList);
        return this;
    }

    public PhenopacketBuilder addMedicalAction(MedicalAction medicalAction) {
        this.builder.addMedicalActions(medicalAction);
        return this;
    }

    public PhenopacketBuilder addFile(File file) {
        this.builder.addFiles(file);
        return this;
    }

    public Phenopacket build() {
        return this.builder.build();
    }

    public PhenopacketBuilder addMedicalActions(List<MedicalAction> previousTreatments) {
        previousTreatments.forEach(arg_0 -> ((Phenopacket.Builder)this.builder).addMedicalActions(arg_0));
        return this;
    }
}

