/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import org.ga4gh.vrs.v1.Allele;
import org.ga4gh.vrs.v1.ChromosomeLocation;
import org.ga4gh.vrs.v1.LiteralSequenceExpression;
import org.ga4gh.vrs.v1.Number;
import org.ga4gh.vrs.v1.SequenceInterval;
import org.ga4gh.vrs.v1.SequenceLocation;
import org.ga4gh.vrs.v1.Variation;

public class AlleleBuilder {
    private final Allele.Builder builder = Allele.newBuilder();
    private final SequenceLocation.Builder slbuilder = SequenceLocation.newBuilder();

    private AlleleBuilder() {
    }

    public AlleleBuilder variantId(String id) {
        this.builder.setId(id);
        return this;
    }

    public AlleleBuilder chromosomeLocation(String chrom) {
        ChromosomeLocation chromosomalLocation = ChromosomeLocation.newBuilder().setChr(chrom).build();
        this.builder.setChromosomeLocation(chromosomalLocation);
        return this;
    }

    public AlleleBuilder interbaseStartEnd(int start, int end) {
        SequenceInterval interval = SequenceInterval.newBuilder().setStartNumber(Number.newBuilder().setValue((long)start)).setEndNumber(Number.newBuilder().setValue((long)end)).build();
        this.slbuilder.setSequenceInterval(interval);
        return this;
    }

    public AlleleBuilder altAllele(String alt) {
        this.builder.setLiteralSequenceExpression(LiteralSequenceExpression.newBuilder().setSequence(alt));
        return this;
    }

    public AlleleBuilder sequenceId(String sequenceId) {
        this.slbuilder.setSequenceId(sequenceId);
        return this;
    }

    public static AlleleBuilder builder() {
        return new AlleleBuilder();
    }

    public Allele build() {
        if (this.slbuilder.hasSequenceInterval()) {
            this.builder.setSequenceLocation(this.slbuilder);
        }
        return this.builder.build();
    }

    public Variation buildVariation() {
        Allele allele = this.build();
        return Variation.newBuilder().setAllele(allele).build();
    }
}

