/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.builder.builders;

import java.util.List;
import org.phenopackets.phenopackettools.builder.builders.PhenotypicFeatureBuilder;
import org.phenopackets.schema.v2.core.Biosample;
import org.phenopackets.schema.v2.core.File;
import org.phenopackets.schema.v2.core.Measurement;
import org.phenopackets.schema.v2.core.OntologyClass;
import org.phenopackets.schema.v2.core.PhenotypicFeature;
import org.phenopackets.schema.v2.core.Procedure;
import org.phenopackets.schema.v2.core.TimeElement;

public class BiosampleBuilder {
    private final Biosample.Builder builder;

    private BiosampleBuilder(String id) {
        this.builder = Biosample.newBuilder().setId(id);
    }

    public static BiosampleBuilder builder(String id) {
        return new BiosampleBuilder(id);
    }

    public BiosampleBuilder individualId(String id) {
        this.builder.setIndividualId(id);
        return this;
    }

    public BiosampleBuilder derivedFromId(String id) {
        this.builder.setDerivedFromId(id);
        return this;
    }

    public BiosampleBuilder description(String desc) {
        this.builder.setDescription(desc);
        return this;
    }

    public BiosampleBuilder sampledTissue(OntologyClass tissue) {
        this.builder.setSampledTissue(tissue);
        return this;
    }

    public BiosampleBuilder sampledType(OntologyClass tissue) {
        this.builder.setSampleType(tissue);
        return this;
    }

    public BiosampleBuilder addPhenotypicFeature(String id, String label) {
        PhenotypicFeature phenotypicFeature = PhenotypicFeatureBuilder.of(id, label);
        return this.addPhenotypicFeature(phenotypicFeature);
    }

    public BiosampleBuilder addPhenotypicFeature(PhenotypicFeature feature) {
        this.builder.addPhenotypicFeatures(feature);
        return this;
    }

    public BiosampleBuilder addAllPhenotypicFeatures(List<PhenotypicFeature> features) {
        this.builder.addAllPhenotypicFeatures(features);
        return this;
    }

    public BiosampleBuilder addMeasurement(Measurement measurement) {
        this.builder.addMeasurements(measurement);
        return this;
    }

    public BiosampleBuilder addAllMeasurements(List<Measurement> measurements) {
        this.builder.addAllMeasurements(measurements);
        return this;
    }

    public BiosampleBuilder taxonomy(OntologyClass taxon) {
        this.builder.setTaxonomy(taxon);
        return this;
    }

    public BiosampleBuilder timeOfCollection(TimeElement time) {
        this.builder.setTimeOfCollection(time);
        return this;
    }

    public BiosampleBuilder histologicalDiagnosis(OntologyClass histologicalDiagnosis) {
        this.builder.setHistologicalDiagnosis(histologicalDiagnosis);
        return this;
    }

    public BiosampleBuilder tumorProgression(OntologyClass progression) {
        this.builder.setTumorProgression(progression);
        return this;
    }

    public BiosampleBuilder tumorGrade(OntologyClass grade) {
        this.builder.setTumorGrade(grade);
        return this;
    }

    public BiosampleBuilder pathologicalStage(OntologyClass stage) {
        this.builder.setPathologicalStage(stage);
        return this;
    }

    public BiosampleBuilder addPathologicalTnmFinding(OntologyClass tnmFinding) {
        this.builder.addPathologicalTnmFinding(tnmFinding);
        return this;
    }

    public BiosampleBuilder addAllPathologicalTnmFindings(List<OntologyClass> tnmFindings) {
        this.builder.addAllPathologicalTnmFinding(tnmFindings);
        return this;
    }

    public BiosampleBuilder addDiagnosticMarker(OntologyClass marker) {
        this.builder.addDiagnosticMarkers(marker);
        return this;
    }

    public BiosampleBuilder addAllDiagnosticMarkers(List<OntologyClass> markers) {
        this.builder.addAllDiagnosticMarkers(markers);
        return this;
    }

    public BiosampleBuilder procedure(Procedure procedure) {
        this.builder.setProcedure(procedure);
        return this;
    }

    public BiosampleBuilder addFile(File file) {
        this.builder.addFiles(file);
        return this;
    }

    public BiosampleBuilder addAllFiles(List<File> files) {
        this.builder.addAllFiles(files);
        return this;
    }

    public BiosampleBuilder materialSample(OntologyClass material) {
        this.builder.setMaterialSample(material);
        return this;
    }

    public BiosampleBuilder sampleProcessing(OntologyClass processing) {
        this.builder.setSampleProcessing(processing);
        return this;
    }

    public BiosampleBuilder sampleStorage(OntologyClass storage) {
        this.builder.setSampleStorage(storage);
        return this;
    }

    public Biosample build() {
        return this.builder.build();
    }
}

